/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.net.URL;
import java.util.HashMap;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.CookieCache;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPClientPool;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing a simple HTTP client
 */
public class SimpleHttpClientPort {
	String proxy_host = null;
	int proxy_port = -1;
	
	static Object cookies_LOCK = new Object();
	static int cookies_ID = 0;
	static HashMap cookies = new HashMap();
	
	public int createCookieCache() {
		synchronized(cookies_LOCK) {
			int id = cookies_ID++;
			Integer oid = new Integer(id);
			cookies.put(oid,new CookieCache());
			return id;
		}
	}
	public void deleteCookieCache(int id) {
		Integer oid = new Integer(id);
		synchronized(cookies_LOCK) {
			cookies.remove(oid);
		}
	}
	
	private CookieCache getCookies(int id) {
		Integer oid = new Integer(id);
		synchronized(cookies_LOCK) {
			CookieCache cache = (CookieCache)cookies.get(oid);
			return cache;
		}
	}
	
	public void setProxy(String host, int port) {
		this.proxy_host = host;
		this.proxy_port = port;
	}
	public String doHttpGet(String urlstr) throws Exception {
		return new String(HTTPClientPool.doGet(new URL(urlstr),new String[0][],proxy_host,proxy_port));
	}
	public String doHttpGet(String urlstr, int cookiesId) throws Exception {
		return new String(HTTPClientPool.doGet(new URL(urlstr),new String[0][],proxy_host,proxy_port,getCookies(cookiesId)));
	}
	public String doHttpPost(String urlstr, String postdata, String mimetype) throws Exception {
		return new String(HTTPClientPool.doPost(new URL(urlstr),postdata.getBytes(),mimetype,new String[0][],proxy_host,proxy_port));
	}
	public String doHttpPost(String urlstr, String postdata, String mimetype, int cookiesId) throws Exception {
		return new String(HTTPClientPool.doPost(new URL(urlstr),postdata.getBytes(),mimetype,new String[0][],proxy_host,proxy_port,getCookies(cookiesId)));
	}
}