/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import java.util.GregorianCalendar;

/**
 * 
 * @author amiguel
 *
 * A WSIF Java port implementing a throughput timer
 */
public class ThroughputTimerPort {
	private static final long ERROR_MARGIN = 100;
	
	public Double getTimeAsDouble() {
		return new Double((double)System.currentTimeMillis());
	}
	public Double getElapsedTimeAsDouble(double time) {
		return new Double(((double)System.currentTimeMillis())-time);
	}
	
	public boolean pollTimer(ThroughputTimerData timer) throws InterruptedException {
		long previous_time = timer.timeMS.getTimeInMillis();
		long next_time = (previous_time + timer.incrementMS);
     	   		
		if (next_time - System.currentTimeMillis() > (2*timer.pollFrequencyMS)) {
			Thread.sleep(timer.pollFrequencyMS);
			
			return false;
		} else {
			long diff = next_time-System.currentTimeMillis();
//if (t3 < -10) {					
//	Logger.direct("Sleep error detected, sleeping for "+%TMP3%+" and launching ("+%TMP1%+" + "+%TMP2%+")");  	   		
//}
			if (diff > 0) {
				Thread.sleep(diff);
//if (System.currentTimeMillis() > next_time) { 	   		
//	Logger.warning("Overshot sleep time by "+(System.currentTimeMillis()-next_time));
//}
			}
			return true;
		}
	}
	
	public ThroughputTimerData incrementTimer(ThroughputTimerData timer) {
		timer.timeMS.setTimeInMillis(timer.timeMS.getTimeInMillis() + timer.incrementMS);
		return timer;
	}
	
	public ThroughputTimerData getTime(ThroughputTimerData timer) {
		timer.timeMS = new GregorianCalendar();
		timer.timeMS.setTimeInMillis(System.currentTimeMillis());
		return timer;
	}
}