/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

//import org.eclipse.core.runtime.Path;
//import org.eclipse.core.runtime.Platform;
//import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlexport.WSDLExportResolver;

public class StandardExportResolver implements WSDLExportResolver {

	String INITIAL_PATH = "http://www.eclipse.org/stp/b2j/2006/02/";
	
	public boolean canResolve(String uri) throws IOException {
		if (uri.startsWith(INITIAL_PATH)) {
			return true;
		} else {
			return false;
		}
	}

	public String getWsdl(String uri) throws IOException {
		uri = uri.substring(INITIAL_PATH.length()-1);
		
//		URL url = Platform.asLocalURL(Platform.find(B2jPlugin.getDefault().getBundle(),new Path(uri)));
//		URL url = new File(B2jPlatform.getPlatformFolder().getAbsolutePath()+"/"+uri).toURL();
		URL url = new File(B2jPlatform.getDependencyInfo("org.eclipse.stp.b2j").getRelativePath("/bpel/"+uri)).toURL();
		
		InputStream in = url.openStream();
		String s = StreamUtils.readAllAsString(in);
		return s;
	}

	public String getBaseUri(String uri) throws IOException {
		uri = uri.substring(INITIAL_PATH.length()-1);
		
//		String s = ""+Platform.asLocalURL(Platform.find(B2jPlugin.getDefault().getBundle(),new Path(uri)));
//		String s = new File(B2jPlatform.getPlatformFolder().getAbsolutePath()+"/"+uri).toURL().toString();
		String s = new File(B2jPlatform.getDependencyInfo("org.eclipse.stp.b2j").getRelativePath("/bpel/"+uri)).toURL().toString();

		int n = s.lastIndexOf('/');
		if (n != -1) {
			s = s.substring(0,n+1);
		}
		return s;
	}

}