/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 *
 * A thread group used by the distributed engine to identify threads that
 * should NOT kill the engine when they die (e.g. program threads)
 */
public class NonCriticalThreadGroup extends ThreadGroup {

ThreadGroupListener listener;
	public NonCriticalThreadGroup() {
		super("NonCriticalThreadGroup");	
	}
	public NonCriticalThreadGroup(ThreadGroupListener listener) {
		super("NonCriticalThreadGroup");	
		this.listener = listener;
	}
	
	public void uncaughtException(Thread t, Throwable e) {
		Logger.info("Non Critical Thread Exit! ("+t.getName()+") - "+t,e);
		if (listener != null) listener.threadException(t,e);
	} 
}