/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.util.LinkedList;

import org.eclipse.stp.b2j.core.jengine.internal.utils.Logger;

/**
 * 
 * @author amiguel
 *
 * Part of the synchronization used in the distributed engine
 */
public class Semaphore {

private Object LOCK = new Object();

LinkedList ids = new LinkedList();
LinkedList counts = new LinkedList();

Controller controller;
int val = 0;
String name;
int id;

Semaphore(String name, int id, int initial, Controller controller) {
	Logger.info("SEMAPHORE: init "+initial);
	this.name = name;
	this.id = id;
	val = initial;
	this.controller = controller;
}

public int getID() {
	return id;
}

public String getName() {
	return name;
}

//public int getSignals() {
	//UNSYNC - because what is there to synchronize? method is inherently
	//unsafe anyway, it will never be guarenteed to give accurate results
//	return val;
//}

public boolean addWait(long id, int count) {
//	Debugger.info("SEMAPHORE: addWait ("+ID.ID_HEX(id)+") "+count);

	synchronized (LOCK) {
		// thread can just go
		if (val >= count) {
			val -= count;
			return true;	
			
		//thread has to wait for a signal
		} else {
			val = 0;
			count -= val;	
			queue(id,count);
			return false;
		}
	}

}

public void addSignal(int sig) throws Exception {
	synchronized (LOCK) {
		val += sig;
		checkQueue();	
	}
}

//StringBuffer history = new StringBuffer();

private void queue(long id, int count) {
	//UNSYNC because addWait() is synchronized
	ids.addLast(new Long(id));
	counts.addLast(new Integer(count));
}

private void checkQueue() throws Exception {
	//UNSYNC because addSignal() is synchronized
	if (ids.isEmpty()) return;
	
	Integer count_o = (Integer)counts.getFirst();
	int count = count_o.intValue();

	while (val >= count) {
		val -= count;

		counts.removeFirst();		
		Long id = (Long)ids.removeFirst();

		controller.signalRunner(id.longValue());
			
		if (ids.isEmpty()) return;
		count_o = (Integer)counts.getFirst();
		count = count_o.intValue();
	}
}
}