/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import org.eclipse.stp.b2j.core.jengine.internal.core.datapool.SharedVariable;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.jengine.internal.mutex.UnqueuedMutex;

/**
 * 
 * @author amiguel
 *
 * Part of the distributed engine internal implementation
 */
public class Variable {

public UnqueuedMutex MUTEX = new UnqueuedMutex();
public Object LOCK = new Object();	
	
String name;
int type;
Object value;
int id;

boolean dirty = true;
boolean dirty_type;
boolean[] dirty_hosts;

Variable(String name, int id, int type) throws Exception {
	this.name = name;
	this.id = id;
	this.type = type;
	
	switch (type) {
		case SharedVariable.INTEGER:
			value = new Integer(0);
			break;		
		case SharedVariable.DOUBLE:	
			value = new Double(0);
			break;		
		case SharedVariable.FLOAT:	
			value = new Float(0);
			break;		
		case SharedVariable.LONG:	
			value = new Long(0);
			break;		
		case SharedVariable.MESSAGE:	
			value = new Message(0);
			break;		
		case SharedVariable.STRING:
			value = new String();
			break;
		case SharedVariable.BYTES:
			value = new byte[0];
			break;
		default:
			throw new Exception("unrecognised type");
	}
	
}

public void setDirtyType(boolean b) {
	dirty_type = b;
}

public boolean getDirtyType() {
	return dirty_type;	
}

public synchronized boolean isDirty() {
	return dirty;
}

public synchronized void setDirty(boolean b) {
	dirty = b;
}

public synchronized void setDirtyHosts(boolean[] b) {
	dirty_hosts = b;
}

public synchronized boolean[] getDirtyHosts() {
	return dirty_hosts;
}

public int getID() {
	return id;
}
	
public String getName() {
	return name;
}
	
public int getType() {
	return type;
}
	
public synchronized void setValue(Object newval) throws ClassCastException {
	value = newval;
}

public synchronized Object getValue() {
	return value;
}
	
}