/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine.api;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;

import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.utils.FileUtil;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class PlatformSoapDaemonConnector extends SoapDaemonConnector {
	
	public PlatformSoapDaemonConnector(SessionAddress address) throws Exception {
		super(address);
	}

	private void updateDaemon(TraceListener tl) throws Exception {
		//update the remote daemon if necessary
		if (!supportsVersion(Version.getVersion())) {
			if (tl != null) tl.debug("Daemon does not support this version - updating Daemon now (this may take a while)");
			
			URL plugin_dir = org.eclipse.core.runtime.Platform.asLocalURL(org.eclipse.core.runtime.Platform.find(B2jPlugin.getDefault().getBundle(),new org.eclipse.core.runtime.Path("/")));
	//		File plugin_file = new File(plugin_dir.getFile());
			File jar_file = new File(plugin_dir.getFile()+"/b2j.jar");
			FileInputStream fin = new FileInputStream(jar_file);
			
			byte[] dat = FileUtil.readFileBinary(fin);
			
			fin.close();
			
			addVersion(Version.getVersion(),dat);
		}
	}
	
	public ControllerInterface newEngine(String description, TraceListener tl, JARDependency[] deps, SessionAddress address) throws Exception {
		
		updateDaemon(tl);
		
		return super.newEngine(description, tl,deps,address);
	}

	public SessionAddress newSubController(int id, JARDependency[] deps, SessionAddress engineaddress) throws Exception {

		updateDaemon(null);
		
		return super.newSubController(id,deps,engineaddress);
	}
}