/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine.api;

import org.eclipse.stp.b2j.core.jengine.internal.Version;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.DaemonInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.core.bpel.WSEndpointReference;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.SOAPClient;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemon;
import org.eclipse.stp.b2j.core.jengine.internal.mainengine.SoapDaemonUtils;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.w3c.dom.Element;

/**
 * 
 * @author amiguel
 *
 * The distributed engine implementation of a Daemon client
 */
public class SoapDaemonConnector implements DaemonInterface {

	WSEndpointReference epr;
	SessionAddress address;
	
	String password;
	
	public SoapDaemonConnector(SessionAddress address) throws Exception {
		this.address = address;
		if (address.getRequiresEncryption()) {
			this.epr = new WSEndpointReference("https://"+address.getListenerHost()+":"+address.getListenerPortMinimum()+"/services/engine/");
		} else {
			this.epr = new WSEndpointReference("http://"+address.getListenerHost()+":"+address.getListenerPortMinimum()+"/services/engine/");
		}
		
		if (address.getRequiresPassword()) {
			this.password = address.getPassword();
		}
		
		//test the connection
		getVersion();
		
	}
	
	private void checkForErrors(Element body_elem) throws Exception {
		Element elem = Util.getFirstElement(body_elem,SoapDaemonUtils.TAG_ERROR);
		if (elem != null) {
			throw new Exception(SoapDaemonUtils.elementToError(elem));
		}
	}
	
	public void addVersion(Message version, byte[] jar) throws Exception {
		StringBuffer request = new StringBuffer();
		
		if (password != null) {
			request.append(SoapDaemonUtils.passwordToElement(password));
		}
		
		request.append(SoapDaemonUtils.versionToElement(version));
		request.append(SoapDaemonUtils.jarToElement(jar));
		
		String response = SOAPClient.invokeRequestResponse(epr,null,null,false,"","",SoapDaemon.SOAPACTION_ADD_VERSION,request.toString());
		
		Element body_elem = SoapDaemonUtils.getResponseBody(response);

		//check for an error response
		checkForErrors(body_elem);
		
		//no further response
	}
	
	public boolean supportsVersion(Message version) throws Exception {
		StringBuffer request = new StringBuffer();
		
		if (password != null) {
			request.append(SoapDaemonUtils.passwordToElement(password));
		}
		
		request.append(SoapDaemonUtils.versionToElement(version));

		String response = SOAPClient.invokeRequestResponse(epr,null,null,false,"","",SoapDaemon.SOAPACTION_SUPPORTS_VERSION,request.toString());
		
		Element body_elem = SoapDaemonUtils.getResponseBody(response);
		
		//check for an error response
		checkForErrors(body_elem);
		
		//part - supported
		Element part_supported = Util.getFirstElement(body_elem,SoapDaemonUtils.TAG_SUPPORTED_VERSION);
		
		return SoapDaemonUtils.elementToSupported(part_supported);
	}
	
	public Message getVersion() throws Exception {
		StringBuffer request = new StringBuffer();
		
		if (password != null) {
			request.append(SoapDaemonUtils.passwordToElement(password));
		}
		
		String response = SOAPClient.invokeRequestResponse(epr,null,null,false,"","",SoapDaemon.SOAPACTION_GET_VERSION,request.toString());
		
		Element body_elem = SoapDaemonUtils.getResponseBody(response);

		//check for an error response
		checkForErrors(body_elem);
		
		//part - versions
		Element part_Versions = Util.getFirstElement(body_elem,SoapDaemonUtils.TAG_VERSIONS);

		//Build Versions
		Message versions = SoapDaemonUtils.elementToVersion(part_Versions);
		
		return versions;
	}
	
	public void close() {
		//do nothing
		//the SOAP implementation will decide when to close this connection etc
	}

	public ControllerInterface newEngine(String description, TraceListener tl, JARDependency[] deps, SessionAddress engineaddress) throws Exception {
		tl.debug("Engine version "+Version.getVersionAsString());
		
		StringBuffer request = new StringBuffer();
		
		if (password != null) {
			request.append(SoapDaemonUtils.passwordToElement(password));
		}
		
		request.append(SoapDaemonUtils.descriptionToElement(description));
		request.append(SoapDaemonUtils.sessionAddressToElement(engineaddress));
		request.append(SoapDaemonUtils.jarDependencyToElement(deps));
		request.append(SoapDaemonUtils.versionToElement(Version.getVersion()));
		
		String response = SOAPClient.invokeRequestResponse(epr,null,null,false,"","",SoapDaemon.SOAPACTION_CREATE_CONTROLLER,request.toString());
		
		Element body_elem = SoapDaemonUtils.getResponseBody(response);

		//check for an error response
		checkForErrors(body_elem);

		//part - SessionAddress
		Element part_SessionAddress = Util.getFirstElement(body_elem,SoapDaemonUtils.TAG_SESSION_ADDRESS);
		
		SessionAddress toconnect = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
		
		ControllerConnector con = new ControllerConnector(toconnect,tl);
		
		return con;
	}

	public SessionAddress newSubController(int id, JARDependency[] deps, SessionAddress engineaddress) throws Exception {

		StringBuffer request = new StringBuffer();
		
		if (password != null) {
			request.append(SoapDaemonUtils.passwordToElement(password));
		}
		
		request.append(SoapDaemonUtils.sessionAddressToElement(engineaddress));
		request.append(SoapDaemonUtils.jarDependencyToElement(deps));
		request.append(SoapDaemonUtils.versionToElement(Version.getVersion()));
		request.append(SoapDaemonUtils.idToElement(id));
		
		String response = SOAPClient.invokeRequestResponse(epr,null,null,false,"","",SoapDaemon.SOAPACTION_CREATE_SUBCONTROLLER,request.toString());
		
		Element body_elem = SoapDaemonUtils.getResponseBody(response);

		//check for an error response
		checkForErrors(body_elem);
		
		//part - SessionAddress
		Element part_SessionAddress = Util.getFirstElement(body_elem,SoapDaemonUtils.TAG_SESSION_ADDRESS);
		
		SessionAddress toconnect = SoapDaemonUtils.elementToSessionAddress(part_SessionAddress);
		
		return toconnect;
	}
	
}