/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.transport.session;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.TCPIPTransportProvider;
import org.eclipse.stp.b2j.core.misc.internal.B2jClassLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * A class to create new Sessions from SessionAddresses
 */
public class SessionFactory {

	public static Session newSession(SessionAddress address, boolean initiator) throws Exception {
		SessionTransport transport = null;
		
		SessionTransportProvider provider = null;
		if (address.getTransportProviderClassName() != null) {
			if (address.getTransportProviderClassName().length() > 0) {
				//load specified transport provider
				try {
					//inside eclipse workbench
					SessionTransportProvider[] providers = SessionTransportLoader.getTransports();
					for (int i = 0; i < providers.length; i++) {
						if (providers[i].getProviderClassName().equals(address.getTransportProviderClassName())) {
							provider = providers[i];
							break;
						}
					}
				} catch (Throwable e) {
					//outside eclipse workbench
					provider = (SessionTransportProvider)B2jClassLoader.load(address.getTransportProviderClassName()).newInstance();
				}
			} else {
				provider = new TCPIPTransportProvider();
			}
		} else {
			provider = new TCPIPTransportProvider();
		}
		
		if (provider == null) {
			throw new Exception("Session transport provider ["+address.getTransportProviderClassName()+"] could not be loaded");
		}
		transport = provider.newInstance(address,initiator);
		
		if (address.getRequiresEncryption()) {
			if (!transport.providesEncryption()) {
				throw new Exception("Session requires encryption but specified transport does not support encryption");
			}
			if (address.getRequiresEncryptionStrengthBits() < transport.getEncryptionStrengthBits()) {
				throw new Exception("Session requires encryption but specified transport does not support encryption of required minimum strength");
			}
		}
		
		if (address.getRequiresAuthentication()) {
			if (!transport.providesEncryption()) {
				throw new Exception("Session requires authentication but specified transport does not support authentication");
			}
		}

		if (address.getRequiresMultipleConnections()) {
			if (address.getRequiresLinkReconnection()) {
				throw new Exception("Sessions that require multiple connections and link reconnection are not supported");
			} 
			if (address.getListenerPortMinimum() != address.getListenerPortMaximum()) {
				throw new Exception("Sessions that require multiple connections and listen on a port range are not supported");
			}
		}

		Session session = new Session(address,transport);
		
		return session;
	}
}