/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * @author amiguel
 * 
 * A utility class to build Long IDs from an Integer subcontroller identifier
 * and an Integer runner identifier
 */
public class ID {

	private ID() {}

	public static long CREATE_ID(int controller_id, int runner_id) {
		long l = controller_id;
		l = (l<<32) | runner_id;
		return l;			
	}

	public static int RUNNER_ID(long id) {
		return (int)(id & 0x00000000FFFFFFFF);			
	}

	public static int RUNNER_INDEX(long id) {
		return RUNNER_ID(id)-1;			
	}

	public static int CONTROLLER_ID(long id) {
		return (int)(id>>>32);			
	}

	public static int CONTROLLER_INDEX(long id) {
		return CONTROLLER_ID(id);			
	}
	
	public static String ID_HEX(long id) {
		StringBuffer sb = new StringBuffer(Long.toHexString(id));
		while (sb.length() < 16) {
			sb.insert(0,'0');	
		}
		return sb.toString();
	}


	
}