/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;

/**
 * 
 * @author amiguel
 *
 * Used to log information about the translation of BPEL into engine Programs
 */
public class TraceListenerTranslatorLog implements TranslatorLog {

	TraceListener listener;
	boolean verbose = false;
	
	public TraceListenerTranslatorLog(TraceListener listener, boolean verbose) {
		this.listener = listener;
		this.verbose = verbose;
	}
	
	public void logInfo(String source, String s) {
		if (verbose) listener.print(source+": "+s);
	}

	public void logWarning(String source, String s) {
		listener.debug(source+": "+s);
	}

	public void logError(String source, String s) {
		listener.debug(source+": "+s);
	}
	

}