/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/**
 * 
 * @author amiguel
 *
 * Used to fork the virtual machine and have the child VM run a given class
 */
public class VMFork {

public static void main(String[] args) {

	System.out.println("Classpath separator = '"+getClassPathSeparator()+"'");

	if (args.length > 0) {
		
		if (args[0].equalsIgnoreCase("memory")) {
			
			int n = 1024;
			try {
				while (true) {
					byte[] b = new byte[n];
					n *= 2;
				}
			} catch (OutOfMemoryError e) {
			}
			
			Runtime r = Runtime.getRuntime();
			System.out.println("<"+n/1024+"k");
		}
		
		return;	
	}
	
	try {
		VMFork fork;
		Process p;
		ProcessPrinter printer;
/*
		fork = new VMFork("Debugger",null,new File("."));
		p = fork.fork();
		printer = new ProcessPrinter(p,System.out,System.err);

		p.waitFor();
*/
		fork = new VMFork("-version",null,new File("."));
		p = fork.fork();
		printer = new ProcessPrinter(p,System.out,System.err);

		p.waitFor();

		fork = new VMFork("VMFork",new String[]{"memory"},new File("."));
		p = fork.fork();
		printer = new ProcessPrinter(p,System.out,System.err);

		p.waitFor();

		fork = new VMFork("VMFork",new String[]{"memory"},new File("."));
		fork.setVMSpecificArgs(new String[]{"-Xmx512m"});
		p = fork.fork();
		printer = new ProcessPrinter(p,System.out,System.err);

		p.waitFor();

	} catch (Exception e) {
		e.printStackTrace();	
	}	
}

private static String getJavaExe() {
	String jhome = System.getProperty("java.home");
	char c = File.separatorChar;
	
	StringBuffer java = new StringBuffer(jhome);
	
	java.append(c);
	java.append("bin");
	java.append(c);
	java.append("java");
	
	return java.toString();
}

private static String getClassPathSeparator() {
	String sep = System.getProperty("path.separator");
	return sep;
}

private static String getClassPath(String[] base_jars, String[] extra_jars) {
	
	String classpath = System.getProperty("java.class.path");
	String sep = getClassPathSeparator();
	
	if (base_jars != null) {
		//these override the current classpath jars
		classpath = "";
		for (int i = 0; i < base_jars.length; i++) {
			classpath = classpath + base_jars[i] + sep;	
		}	
	}
	
	if (extra_jars != null) {
		for (int i = 0; i < extra_jars.length; i++) {
			if (!classpath.endsWith(sep)) {
				classpath = classpath + sep;
			}
			classpath = classpath + extra_jars[i];	
		}	
	}
	
	return classpath;
}

	String cname;
	String[] args;
	String[] vmargs;
	String[] jars;
	String[] basejars;
	File dir;

	/**
	 * Create a new VMFork object (allows the current virtual machine to be forked in a non platform-specific way)
	 * @param cname the name of the class to run in the new VM
	 */
	public VMFork(String cname) {
		this.cname = cname;
	}

	/**
	 * Create a new VMFork object (allows the current virtual machine to be forked in a non platform-specific way)
	 * @param cname the name of the class to run in the new VM
	 * @param args the arguments to pass to the main class of the new VM (may be null - defaults to no arguments)
	 */
	public VMFork(String cname, String[] args) {
		this.cname = cname;
		this.args = args;
	}

	/**
	 * Create a new VMFork object (allows the current virtual machine to be forked in a non platform-specific way)
	 * @param cname the name of the class to run in the new VM
	 * @param args the arguments to pass to the main class of the new VM (may be null - defaults to no arguments)
	 * @param working_dir the directory to run the VM in (may be null - defaults to current working dir)
	 */
	public VMFork(String cname, String[] args, File working_dir) {
		this.cname = cname;
		this.args = args;
		this.dir = working_dir;
	}
	
	public void setClassName(String cname) {
		this.cname = cname;
	}
	
	public void setClassArgs(String[] args) {
		this.args = args;	
	}

	public void setVMSpecificArgs(String[] args) {
		this.vmargs = args;	
	}
	
	public void setClasspathExtras(String[] jars) {
		this.jars = jars;
	}
	
	public void setWorkingDir(File dir) {
		this.dir = dir;	
	}
	
	public void setBaseClasspath(String[] jars) {
		this.basejars = jars;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();
		try {
			fork(sb);
		} catch (Exception e) {
			sb.append("VMFork problem: "+e);
		}
		return sb.toString();
	}
	
	/**
	 * Fork this JVM based on the settings of this VMFork object
	 * @return the process representing the new java virtual machine instance
	 * @throws IOException if an error occurs while forking the virtual machine
	 */
	public Process fork() throws IOException {
		return fork(null);
	}

	private Process fork(StringBuffer cmd) throws IOException {
		
		String java_exe = getJavaExe();
		String classpath = getClassPath(basejars,jars);

		if (args == null) args = new String[0];
		if (vmargs == null) vmargs = new String[0];

		ArrayList commands = new ArrayList();
		
		commands.add(java_exe);
		if (classpath.length() > 0) {
			commands.add("-cp");
			commands.add(classpath);
		}
		for (int i = 0; i < vmargs.length; i++) {
			commands.add(vmargs[i]);
		}
		commands.add(cname);
		for (int i = 0; i < args.length; i++) {
			commands.add(args[i]);
		}
		
		String[] commands_array = new String[commands.size()];
		commands.toArray(commands_array);
		
/*		
		String[] commands = new String[ 4 + vmargs.length + args.length];
		
		int n = 0;
		commands[n++] = java_exe;
		commands[n++] = "-cp";
		commands[n++] = classpath;
		for (int i = 0; i < vmargs.length; i++) {
			commands[n++] = vmargs[i];
		}
		commands[n++] = cname;
		for (int i = 0; i < args.length; i++) {
			commands[n++] = args[i];
		}
*/		
		if (cmd == null) {
			Process p = Runtime.getRuntime().exec(commands_array,null,dir);
			return p;
		} else {
			for (int i = 0; i < commands_array.length; i++) {
				cmd.append("CMD:"+commands_array[i]).append("\n");	
			}
			return null;
		}
	}
}
