/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.utils;

/**
 * 
 * @author amiguel
 *
 * A runtime class used to implement XPATH expression
 */
public class XNode {
public String name;
public XPathAccessible value;
public XNode parent;

public Object[] container;
public int containerIndex;

	public XNode(String name, Object value, Object[] container, int containerIndex, XNode parent) {
		this.name = name;
		this.value = (XPathAccessible)value;
		this.parent = parent;
		this.container = container;
		this.containerIndex = containerIndex;
	}
	
	public XNode getParent() {
		return parent;
	}
	
	public XPathAccessible getValue() {
		return value;
	}
	public void setValueInContainer(Object o) throws Exception {
		setValueInContainer(o,false);
	}
	public void setValueInContainer(Object o, boolean ignoreNoContainer) throws Exception {
		try {
			value = (XPathAccessible)o;
			if (!ignoreNoContainer || container != null) {
				container[containerIndex] = o;
			}
		} catch (ArrayStoreException e) {
			Logger.error("Tried to set element in array of type "+container.getClass().getName()+" to object of type "+o.getClass().getName(),e);
		}
	}
		
	public String toString() {
		return value.toXpathStringValue();
	}
	
	public void toString(StringBuffer sb) {
		value.appendXpathStringValue(sb);
	}
	
}