/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.misc.internal;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;

public class B2jClassLoader {
	public static Class load(String classname) throws ClassNotFoundException {
		
		try {
			return Class.forName(classname);
		} catch (Exception x) {
			ArrayList list = new ArrayList();
			
			DependencyInfo[] deps = B2jPlatform.getAllDependencyInfo();
			for (int i = 0; i < deps.length; i++) {
				Properties[] resprops = deps[i].getResources();
				for (int k = 0; k < resprops.length; k++) {
					String relpath = resprops[k].getProperty("JAR");
					String abspath = deps[i].getRelativePath(relpath);
					
					try {
						URL url = new File(abspath).toURL();
						list.add(url);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
	
			URL[] urls = new URL[list.size()];
			list.toArray(urls);
			
			URLClassLoader cl = new URLClassLoader(urls,B2jClassLoader.class.getClassLoader());
			return cl.loadClass(classname);
		}
/*		
		try {
			return Class.forName(classname);
		} catch (Exception e) {
			try {
				return Thread.currentThread().getContextClassLoader().loadClass(classname);
			} catch (Exception e2) {
				try {
					return ClassLoader.getSystemClassLoader().loadClass(classname);
				} catch (Exception e3) {
					try {
						return PlatformClassLoader.load(classname);
					} catch (Exception e4) {
						throw new ClassNotFoundException("Unable to load class "+classname);
					}
				}
			}
//			Platform.getBundleGroupProviders()[0].getBundleGroups()[0].getBundles()[0].loadClass();
//			providers[0].
		}*/
	}
	
	/*
	public static Class load(String name) throws Exception {
		return Platform.class.getClassLoader().loadClass(name);
		int n = 0;
		
		Object[] providers = (Object[])Class.forName("org.eclipse.core.runtime.Platform").getMethod("getBundleGroupProviders",new Class[0]).invoke(null,new Object[0]);
		for (int i = 0; i < providers.length; i++) {
			Object[] groups = (Object[])Class.forName("org.eclipse.core.runtime.IBundleGroupProvider").getMethod("getBundleGroups",new Class[0]).invoke(providers[i],new Object[0]);
			for (int k = 0; k < groups.length; k++) {
				Object[] bundles = (Object[])Class.forName("org.eclipse.core.runtime.IBundleGroup").getMethod("getBundles",new Class[0]).invoke(groups[k],new Object[0]);
				for (int z = 0; z < bundles.length; z++) {
					try {
						n++;
						Class c = (Class)Class.forName("org.osgi.framework.Bundle").getMethod("loadClass",new Class[]{String.class}).invoke(bundles[z],new Object[]{name});
						return c;
					} catch (InvocationTargetException e) {
						System.err.println("Failed to load class from bundle "+bundles[z].getClass().getMethod("getSymbolicName",new Class[0]).invoke(bundles[z],new Object[0])+" : "+e.getTargetException());
					} catch (Exception e) {
						System.err.println("Failed to load class from bundle "+bundles[z].getClass().getMethod("getSymbolicName",new Class[0]).invoke(bundles[z],new Object[0])+" : "+e);
					}
				}
			}
		}
		
		
		
		new Exception("Failed to load class from "+n+" bundles").printStackTrace();
		
		Platform.getBundleGroupProviders()[0].getBundleGroups()[0].getBundles()[0].loadClass(name);
		throw new Exception("Unable to load class "+name);
	}
*/	
}