/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class B2jConfig {
	
	public static final String PATH_SOAPDAEMON_PORT = "Config/SoapDaemon/Port";
	public static final String PATH_SOAPDAEMON_SSL = "Config/SoapDaemon/SSL";
	public static final String PATH_SOAPDAEMON_USE_PASSWORD = "Config/SoapDaemon/UsePassword";
	public static final String PATH_SOAPDAEMON_PASSWORD = "Config/SoapDaemon/Password";
	public static final String PATH_SOAPDAEMON_LOG_INFO = "Config/SoapDaemon/LogInfo";

	public static final String PATH_SOAP_HTTP_PROXY_USE = "Config/Soap/HttpProxy/Use";
	public static final String PATH_SOAP_HTTP_PROXY_HOST = "Config/Soap/HttpProxy/Host";
	public static final String PATH_SOAP_HTTP_PROXY_PORT = "Config/Soap/HttpProxy/Port";

	public static final String PATH_SOAP_HTTPS_PROXY_USE = "Config/Soap/HttpsProxy/Use";
	public static final String PATH_SOAP_HTTPS_PROXY_HOST = "Config/Soap/HttpsProxy/Host";
	public static final String PATH_SOAP_HTTPS_PROXY_PORT = "Config/Soap/HttpsProxy/Port";

	public static final String PATH_SOAP_EXCLUDED_PROXY_HOSTS = "Config/Soap/ExcludedProxyHosts";

	public static final String PATH_JVMFORK_FORK = "Config/JvmFork/Fork";
	public static final String PATH_JVMFORK_EXTRA_CLASSPATH = "Config/JvmFork/ExtraClasspath";

	public static final String PATH_JVMFORK_FORK_COMMAND_JAVAEXE = "Config/JvmFork/ForkCommand/JavaExe";
	public static final String PATH_JVMFORK_FORK_COMMAND_JAVA_CLASSPATH_ARG = "Config/JvmFork/ForkCommand/JavaClasspathArg";
	public static final String PATH_JVMFORK_FORK_COMMAND_JAVA_VM_ARG = "Config/JvmFork/ForkCommand/JavaVmArg";
	
	File file;
	Document doc;
	
	public B2jConfig(File file) throws Exception {
		this.file = file;
		
		DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = fac.newDocumentBuilder();
		doc = builder.parse(file);
	}
	
	public String getProperty(String path) {
		String[] tmp = getProperties(path);
		if (tmp.length == 0) {
			return null;
		}
		return tmp[0];
	}
	public String[] getProperties(String path) {
		return getElems(path);
	}
	public void setProperties(String path, String[] properties) {
		//TODO to allow the preferences pages to set properties like proxies etc
	}
	
	private String[] getElems(String path) {
		String[] paths = path.split("/");
		
		Element e = doc.getDocumentElement();
		
		ArrayList list = new ArrayList();
		getElems(paths,0,e,list);
		
		String[] results = new String[list.size()];
		list.toArray(results);
		return results;
	}
	private void getElems(String[] paths, int index, Element e, List results) {
		
		if (index == paths.length) {
			results.add(Util.getTextDirectlyUnder(e));
		} else {
			
			NodeList list = e.getElementsByTagName(paths[index]);
			
			for (int k = 0; k < list.getLength(); k++) {
				Element elem = (Element)list.item(k);
				getElems(paths,index+1,elem,results);
			}
		}
	}
}