/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi;

import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;

public class DependencyInfo {
	
	String ID;
	String Version;
	
	String localPath;
	
	ArrayList resources = new ArrayList();
	ArrayList wsdlbindings = new ArrayList();
	ArrayList wsdlresolvers = new ArrayList();
	ArrayList portdependencies = new ArrayList();
	ArrayList sessiontransports = new ArrayList();
	ArrayList prerunservices = new ArrayList();
	
	public DependencyInfo(String id, String version, String localPath) {
		ID = id;
		Version = version;
		this.localPath = localPath;
	}
	
	public String getRelativePath(String relativePath) {
		return localPath+relativePath;
	}
	
	public Properties[] getResources() {
		Properties[] tmp = new Properties[resources.size()];
		resources.toArray(tmp);
		return tmp;
	}
	public Properties[] getWSDLBindings() {
		Properties[] tmp = new Properties[wsdlbindings.size()];
		wsdlbindings.toArray(tmp);
		return tmp;
	}
	public Properties[] getWSDLResolvers() {
		Properties[] tmp = new Properties[wsdlresolvers.size()];
		wsdlresolvers.toArray(tmp);
		return tmp;
	}
	public Properties[] getPortDependencies() {
		Properties[] tmp = new Properties[portdependencies.size()];
		portdependencies.toArray(tmp);
		return tmp;
	}
	public Properties[] getSessionTransports() {
		Properties[] tmp = new Properties[sessiontransports.size()];
		sessiontransports.toArray(tmp);
		return tmp;
	}
	public Properties[] getPreRunServices() {
		Properties[] tmp = new Properties[prerunservices.size()];
		prerunservices.toArray(tmp);
		return tmp;
	}
	
	public String getId() {
		return ID;
	}
	public String getVersion() {
		return Version;
	}
	
	public boolean isEngineDependant() {
		return sessiontransports.size() > 0;
	}
	
	public boolean olderThan(DependencyInfo d) {
		int[] myVersion = parseVersion(Version);
		int[] otherVersion = parseVersion(d.Version);
		
		for (int i = 0; i < Math.min(myVersion.length,otherVersion.length); i++) {
			if (myVersion[i] < otherVersion[i]) {
				//we are older
				return true;
			} else if (myVersion[i] > otherVersion[i]) {
				//they are older
				return false;
			}
		}
		
		if (otherVersion.length > myVersion.length) {
			return true; 
		} else if (myVersion.length > otherVersion.length) {
			return false;
		}
		
		return false;
	}
	
	private int[] parseVersion(String v) {
		char[] dat = v.toCharArray();
		
		for (int i = 0; i < dat.length; i++) {
			if (!Character.isDigit(dat[i])) {
				dat[i] = ' ';
			}
		}
		
		CharStack cs = new CharStack(new String(dat));
		
		ArrayList numbers = new ArrayList();
		
		try {
			while (true) {
				cs.popWhitespace();
				numbers.add(new Integer((int)cs.popNumber()));
			}
		} catch (Exception e) {
		}
		
		int[] tmp = new int[numbers.size()];
		for (int i = 0; i < tmp.length; i++) {
			tmp[i] = ((Number)numbers.get(i)).intValue();
		}
		return tmp;
	}
}