/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding;

import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.stp.b2j.core.jengine.internal.utils.ClassPathHacker;
import org.eclipse.stp.b2j.core.misc.internal.B2jClassLoader;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;

/**
 * 
 * @author amiguel
 *
 * A utility class to load all extensions of the WSDL Binding extension point.
 */
public class WSDLBindingLoader {

/*
	public static WSDLBindingTranslator[] getBindings() throws Exception {
		ArrayList translators = getExtensionPointClasses(B2jPlugin.EXTENSION_POINT_WSDLBINDING);
		
		for (int i = 0; i < translators.size(); i++) {
			WSDLBindingTranslator translator = (WSDLBindingTranslator)translators.get(i);
			if (!B2jPlugin.getDefault().getPreferenceStore().getBoolean(PreferenceConstants.getBindingEnabledKey(translator))) {
				//this binding is disabled
				translators.remove(i--);
			}
		}
		
		WSDLBindingTranslator[] array = new WSDLBindingTranslator[translators.size()];
		translators.toArray(array);
		return array;
	}
*/
	
	public static WSDLBindingTranslator[] getBindingsUnfiltered() throws Exception {
		ArrayList translators = getExtensionPointClasses();
		WSDLBindingTranslator[] array = new WSDLBindingTranslator[translators.size()];
		translators.toArray(array);
		return array;
	}
	
	private static ArrayList getExtensionPointClasses() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
		ArrayList classes = new ArrayList();
		
		DependencyInfo[] deps = B2jPlatform.getAllDependencyInfo();
		for (int i = 0; i < deps.length; i++) {
			Properties[] props = deps[i].getResources();
			for (int k = 0; k < props.length; k++) {
				try {
					ClassPathHacker.addFile(deps[i].getRelativePath(props[k].getProperty("JAR")));
				} catch (Exception e) {}
			}
			
			props = deps[i].getWSDLBindings();
			for (int k = 0; k < props.length; k++) {
				String classname = props[k].getProperty("Class");
				
				try {
					Class z;
					try {
						z = B2jClassLoader.load(classname);
					} catch (ClassNotFoundException e) {
						z = WSDLBindingLoader.class.getClassLoader().loadClass(classname);
					}
					
					try {
						classes.add(z.newInstance());
						//TODO add the dependency into here?
					} catch (Exception e) {
						System.out.println("Unable to load binding "+classname);
					}
				} catch (NoClassDefFoundError x) {
					System.out.println("Unable to load binding "+classname);
					throw x;
				}
			}
		}
		
		return classes;
	}
	
}