/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.TranslatorLog;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.w3c.dom.Element;

/**
 * 
 * @author amiguel
 *
 * An interface which WSDL binding type extensions must implement.  Can
 * be called by the translator classes to add java source which makes
 * use of a particular binding type.
 */
public interface WSDLBindingTranslator {
	
	/**
	 * This is the initialisation function.  It is always called first.
	 * @param xsdmap an XSDMap object to give this translator all the necessary type information
	 * @param wsdlmap a WSDLMap object to give this translator all the necessary wsdl interface information
	 */
	public void init(Util compiler_util, TranslatorLog log, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependency_loader);

	public String getID();
	public String getHumanReadableName();
	
	public void readWSDL(Element wsdl_definitions) throws NamespaceException, WSDLBindingTranslatorException;

	public XSDTypeTranslator[] getCodecs();
	
	public String translateInvocation(NamespaceTranslator nt, String qportType, String requiredBinding, String operation, String eprFieldName, String correlationSetFieldNameIn, String correlationSetFieldNameOut, String inputFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException;
	public String translateReceive(NamespaceTranslator nt, String qportType, String requiredBinding, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException;
	public String translateReply(NamespaceTranslator nt, String qportType, String requiredBinding, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String outputFieldName) throws NamespaceException, WSDLBindingTranslatorException;
	public String translateDefaultEPR(NamespaceTranslator nt, String qportType, String requiredBinding) throws NamespaceException, WSDLBindingTranslatorException;

	public void translatePickStart(int onMessageCount, int onAlarmCount, String timeoutFieldLongMS) throws NamespaceException, WSDLBindingTranslatorException;
	public void translatePickOnMessage(NamespaceTranslator nt, String qportType, String requiredBinding, String operation, String messageExchange, String eprFieldName, String correlationSetFieldName, String inputFieldName) throws NamespaceException, WSDLBindingTranslatorException;
//	public void translatePickOnAlarm(String timeoutFieldLongMs) throws NamespaceException, BindingTranslatorException;
	public String translatePickFinish(String indexFieldName) throws NamespaceException, WSDLBindingTranslatorException;
	
	public String getDeclarations();
	public String[] getImports();
}