/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap.WSDLMap;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xsdmap.XSDMap;
import org.w3c.dom.Element;

/**
 * 
 * @author amiguel
 *
 * An interface to represent a type translation class that a WSDL binding
 * translator may need.
 */
public interface XSDTypeTranslator {
	
	public static final String XSD_TYPE_STRING = "xsd:string";
	public static final String XSD_TYPE_NORMALIZEDSTRING = "xsd:normalizedString";
	public static final String XSD_TYPE_TOKEN = "xsd:token";

	public static final String XSD_TYPE_BYTE = "xsd:byte";
	public static final String XSD_TYPE_UNSIGNEDBYTE = "xsd:unsignedByte";

	public static final String XSD_TYPE_BASE64BINARY = "xsd:base64Binary";
	public static final String XSD_TYPE_HEXBINARY = "xsd:hexBinary";

	public static final String XSD_TYPE_INTEGER = "xsd:integer";
	public static final String XSD_TYPE_POSITIVEINTEGER = "xsd:positiveInteger";
	public static final String XSD_TYPE_NEGATIVEINTEGER = "xsd:negativeInteger";
	public static final String XSD_TYPE_NONPOSITIVEINTEGER = "xsd:nonPositiveInteger";
	public static final String XSD_TYPE_NONNEGATIVEINTEGER = "xsd:nonNegativeInteger";

	public static final String XSD_TYPE_INT = "xsd:int";
	public static final String XSD_TYPE_UNSIGNEDINT = "xsd:unsignedInt";
	public static final String XSD_TYPE_LONG = "xsd:long";
	public static final String XSD_TYPE_UNSIGNEDLONG = "xsd:unsignedLong";

	public static final String XSD_TYPE_SHORT = "xsd:short";
	public static final String XSD_TYPE_UNSIGNEDSHORT = "xsd:unsignedShort";

	public static final String XSD_TYPE_DECIMAL = "xsd:decimal";
	public static final String XSD_TYPE_FLOAT = "xsd:float";
	public static final String XSD_TYPE_DOUBLE = "xsd:double";

	public static final String XSD_TYPE_BOOLEAN = "xsd:boolean";

	public static final String XSD_TYPE_TIME = "xsd:time";
	public static final String XSD_TYPE_DATETIME = "xsd:dateTime";
	public static final String XSD_TYPE_DURATION = "xsd:duration";
	public static final String XSD_TYPE_DATE = "xsd:date";

	public static final String XSD_TYPE_GMONTH = "xsd:gMonth";
	public static final String XSD_TYPE_GYEAR = "xsd:gYear";
	public static final String XSD_TYPE_GYEARMONTH = "xsd:gYearMonth";
	public static final String XSD_TYPE_GDAY = "xsd:gDay";
	public static final String XSD_TYPE_GMONTHDAY = "xsd:gMonthDay";
	
	public static final String XSD_TYPE_NAME = "xsd:Name";
	public static final String XSD_TYPE_QNAME = "xsd:QName";
	public static final String XSD_TYPE_NCNAME = "xsd:NCName";
	public static final String XSD_TYPE_ANYURI = "xsd:anyURI";
	public static final String XSD_TYPE_LANGUAGE = "xsd:language";
	public static final String XSD_TYPE_ID = "xsd:ID";
	public static final String XSD_TYPE_IDREF = "xsd:IDREF";
	public static final String XSD_TYPE_IDREFS = "xsd:IDREFS";
	public static final String XSD_TYPE_ENTITY = "xsd:ENTITY";
	public static final String XSD_TYPE_ENTITIES = "xsd:ENTITIES";
	public static final String XSD_TYPE_NOTATION = "xsd:NOTATION";
	public static final String XSD_TYPE_NMTOKEN = "xsd:NMTOKEN";
	public static final String XSD_TYPE_NMTOKENS = "xsd:NMTOKENS";

//
// XSD special cases
//
	public static final String XSD_TYPE_ANYTYPE = "xsd:anyType";
	public static final String XSD_TYPE_LIST = "xsd:list";

	/**
	 * This is the initialisation function.  It is always called first.
	 * @param xsdmap an XSDMap object to give this codec all the necessary type information
	 * @param wsdlmap a WSDLMap object to give this codec all the necessary wsdl interface information
	 */
	public void init(Util compiler_util, XSDMap xsdmap, WSDLMap wsdlmap, ClassLoader dependency_loader);

	/**
	 * This function is called for each WSDL file.  The codec should read any pertinent binding information
	 * from this file.
	 * To get information about the types defined across this web service, the codec should use the provided
	 * XSDMap.
	 * To get information about the WSDL interfaces defined across this web service, the codec should use the
	 * provided WSDLMap.
	 * @param wsdl_definitions the WSDL to read
	 * @throws XSDTypeTranslatorException
	 * @throws NamespaceException
	 */
	public void readWSDL(Element wsdl_definitions) throws XSDTypeTranslatorException, NamespaceException;
	
	public void translateComplex(NamespaceTranslator nt, String name, String[] attrtypes, String[] attributes, String[] types, String[] names, String[] elems, Element complex) throws XSDTypeTranslatorException, NamespaceException;

	public void translateSimple(NamespaceTranslator nt, String name, String base, Element simple) throws XSDTypeTranslatorException, NamespaceException;

	public void translateBase(NamespaceTranslator nt, String name) throws XSDTypeTranslatorException, NamespaceException;
	
	/**
	 * Returns a java class body with any method implementations for this particular complex type
	 * @return
	 */
	public String getMethods();
	
	/**
	 * Returns an array of interfaces that this complex type will be said to implement
	 * @return
	 */
	public String[] getImplementations();

	/**
	 * Returns an array of imports that this complex type will need
	 * @return
	 */
	public String[] getImports();
}