/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.importresolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlexport.WSDLExportLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlexport.WSDLExportResolver;

public class StandardWsdlImportResolver implements WsdlImportResolver {

	public String fetchUrl(URL url, boolean use_cache, boolean add_to_cache) throws IOException {
		//TODO read proxy settings from the b2j conf file here
		B2jPlatform.getPlatformFolder();
		
/*		if (use_proxy) {
			System.setProperty("http.proxyHost",proxy_host);
			System.setProperty("http.proxyPort",proxy_port);
			System.setProperty("https.proxyHost",proxy_host);
			System.setProperty("https.proxyPort",proxy_port);
		}*/
	
		//
		// Check the WSDL resolver extension points
		//
		try {
			String uri = url.toString();
			
			WSDLExportResolver[] resolvers = WSDLExportLoader.getWsdlExportResolvers();
			for (int i = 0; i < resolvers.length; i++) {
				try {
					if (resolvers[i].canResolve(uri)) {
						//this resolver can provide us with the WSDL at this address
						return resolvers[i].getWsdl(uri);
					} else {
						System.out.println("Resolver "+resolvers[i].getClass().getName()+" cannot resolve "+uri);
					}
				} catch (IOException e) {
					System.out.println("Error while querying WSDL export resolver "+resolvers[i].getClass().getName()+": "+e);
				}
			}
		} catch (Exception e) {
			System.out.println("Failed to load WSDL export resolvers"+": "+e);
		}
		
		/*
			IPreferenceStore store = B2jPlugin.getDefault().getPreferenceStore();
			
			//
			// Search the cache
			//
			if (use_cache) {
				int size = store.getInt(PreferenceConstants.CACHE_SIZE);
				for (int i = 0; i < size; i++) {
					String loc = store.getString(PreferenceConstants.CACHE_LOCATION+i);
//	System.out.println("CACHE CHECK - "+url.toString()+" vs "+loc);					
					if (loc.equals(url.toString())) {
//	System.out.println("CACHE HIT! - "+url.toString());					
						return store.getString(PreferenceConstants.CACHE_CONTENT+i);
					}
				}
			}
//	System.out.println("CACHE MISS! - "+url.toString());	*/				

		InputStream in = url.openStream();
		String contents = StreamUtils.readAllAsString(in);
		in.close();
		/*
		//
		// Populate the cache
		//
		if (store_to_cache) {
			if (url.getProtocol().equals("file")) {
				//dont cache local files
			} else {
				int size = store.getInt(PreferenceConstants.CACHE_SIZE) + 1;
				store.setValue(PreferenceConstants.CACHE_SIZE,size);
				store.setValue(PreferenceConstants.CACHE_LOCATION+(size-1),url.toString());
				store.setValue(PreferenceConstants.CACHE_CONTENT+(size-1),contents);
			}
		}*/
		
		return contents;
	}

}