/**********************************************************************
 * Copyright (c) 2006 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.jcompiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.utils.JARFinder;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.misc.internal.Debugger;
import org.eclipse.stp.b2j.core.misc.internal.MultiOutputStream;
import org.eclipse.stp.b2j.core.publicapi.B2jPlatform;
import org.eclipse.stp.b2j.core.publicapi.DependencyInfo;

public class WorkbenchJDTJavaCompiler implements JavaCompiler {

	Debugger DBG = B2jPlugin.DBG;
	
	CompilerUnit mainsrc;
	CompilerUnit[] allsrc = new CompilerUnit[1];
	
	byte[] theclass;
	byte[][] classes;
	
	public void setMainSourceFile(CompilerUnit src) {
		mainsrc = src;
		allsrc[0] = mainsrc;
	}

	public void addExtraSources(CompilerUnit[] sources) {
		CompilerUnit[] tmp = new CompilerUnit[allsrc.length + sources.length];
		System.arraycopy(allsrc,0,tmp,0,allsrc.length);
		System.arraycopy(sources,0,tmp,allsrc.length,sources.length);
		allsrc = tmp;
	}

	public void compile() throws Exception {
		File file = File.createTempFile("WorkbenchJDTJavaCompilation","");

		file.delete();
		if (!file.mkdirs()) {
			Exception e = new Exception("problem creating temporary compilation directory:"+file);
			DBG.error("Problem compiling:",e);
			throw e;	
		}
		
		
		String dir = file.getCanonicalPath();
		if (!dir.endsWith(File.separator)) dir = dir+File.separator;

		DBG.info("Writing java source code to tmp directory "+dir);

		int CONFIGS_LEN = 6;

		String[] srcnames = new String[CONFIGS_LEN + allsrc.length];

		FileOutputStream allout = null;
		try {
		
//TODO hard coded debug path
			allout = new FileOutputStream("C:\\temp\\ALLSRC.java");
			
			new File("C:\\temp\\ALLSRC").mkdirs();
		} catch (Exception e) {
			DBG.warning("Could not open generated source debugging file",e);
			allout = null;
		}
		
		for (int i = 0; i < allsrc.length; i++) {
			String pkgname = allsrc[i].getPackageName();
			String cname = allsrc[i].getClassName();
			String srcname = getSrcName(pkgname,cname);
			
			File tmpfile = new File(dir+srcname);
			//make any necessary directories for this source file.
			tmpfile.mkdirs();
			tmpfile.delete();

			srcnames[CONFIGS_LEN + i] = dir+srcname;

			FileOutputStream fout = new FileOutputStream(dir+srcname);
			fout.write(allsrc[i].toString().getBytes());
			fout.flush();
			
			try {
				if (allout != null) {
					allout.write(allsrc[i].toString().getBytes());
				}
			} catch (Exception e) {
				DBG.warning("Failed to write to generated source debugging file",e);
				allout = null;
			}
			
			try {
				String fname = pkgname;
				fname = fname.substring(fname.indexOf('.')+1);
				fname = fname.replace('.','_');
				fname = fname + cname;
				FileOutputStream tmpfout = new FileOutputStream("C:\\temp\\ALLSRC\\"+fname+".java");
				tmpfout.write(allsrc[i].toString().getBytes());
				tmpfout.close();
			} catch (Exception e) {
				
			}
			
			fout.close();
			
			DBG.info("Wrote java source for "+srcname);
		}
		
		if (allout != null) {
			allout.flush();
			allout.close();
		}

		URL plugin_dir = Platform.asLocalURL(Platform.find(B2jPlugin.getDefault().getBundle(),new Path("/")));
		File plugin_file = new File(plugin_dir.getFile());
		File jar_file = new File(plugin_dir.getFile()+"/b2j.jar");
		
		ArrayList jars = new ArrayList();
		
		DependencyInfo[] infos = B2jPlatform.getAllDependencyInfo();
		for (int i = 0; i < infos.length; i++) {
			Properties[] props = infos[i].getResources();
			for (int k = 0; k < props.length; k++) {
				jars.add(infos[i].getRelativePath(props[k].getProperty("JAR")));
//				jars.add(plugin_dir.getFile()+"/dependencies/"+props[k].getProperty("JAR"));
			}
		}
		
		srcnames[0] = "-classpath";

		StringBuffer cpath = new StringBuffer();
		cpath.append(jar_file.getAbsolutePath());
		for (int i = 0; i < jars.size(); i++) {
			cpath.append(System.getProperty("path.separator"));
			cpath.append((String)jars.get(i));
		}
		
		srcnames[1] = cpath.toString();
		
		srcnames[2] = "-d";
		srcnames[3] = dir;

		srcnames[4] = "-noExit";
		srcnames[5] = "-nowarn";
		
		DBG.info("CLASSPATH = "+srcnames[1]);
		
		System.gc();
		
		ByteArrayOutputStream compiler_out = new ByteArrayOutputStream();
		
		PrintWriter mout = new PrintWriter(
			new PrintStream(
				new MultiOutputStream(
					new OutputStream[]{
							System.err,
							compiler_out,
					}
				)
			)
		);
		
//		org.eclipse.jdt.internal.compiler.batch.Main compiler = new org.eclipse.jdt.internal.compiler.batch.Main(new PrintWriter(System.out), new PrintWriter(System.err), false);
		org.eclipse.jdt.internal.compiler.batch.Main compiler = new org.eclipse.jdt.internal.compiler.batch.Main(mout, mout, false);

		boolean compiledOK = compiler.compile(srcnames);
		
		if (!compiledOK) {
			deleteDirs(dir);
			throw new Exception("Translated BPEL compilation failed\n\nCompiler Output:\n\n"+new String(compiler_out.toByteArray())+"\n\n");
		}
//		org.eclipse.jdt.internal.compiler.batch.Main.main(srcnames); 

		ArrayList cpaths = new ArrayList();
		JARFinder.searchDir(cpaths,new File(dir),".class",1000);

		String cfname = getClassFileName(allsrc[0].getClassName());
		theclass = null;

		classes = new byte[cpaths.size()-1][];
		for (int i = 0; i < cpaths.size(); i++) {
			String path = (String)cpaths.get(i);
			FileInputStream fin = new FileInputStream(path);
			System.out.println(cfname+" ? "+path);
			if (path.endsWith(cfname)) {
				theclass = StreamUtils.readAll(fin);
			} else {
				if (theclass == null) {
					classes[i] = StreamUtils.readAll(fin);
				} else {
					classes[i-1] = StreamUtils.readAll(fin);
				}
			}
			fin.close();
		}

		deleteDirs(dir);
	}

	public byte[] getMainSourceClass() {
		return theclass;
	}

	public byte[][] getExtraSourceClasses() {
		return classes;
	}

	
	private void deleteDirs(String dir) {
		File f = new File(dir);
		if (f.isDirectory()) {
			File[] files = f.listFiles();
			for (int i = 0; i < files.length; i++) {
				deleteDirs(files[i].getAbsolutePath());
			}
//			System.out.println("DELETING "+f);
			f.delete();
		} else {
//			System.out.println("DELETING "+f);
			f.delete();
		}
	}

	private String getClassFileName(String cname) {
		return cname.substring(cname.lastIndexOf('.')+1) + ".class";
	}
	
	private String getSrcName(String pkgname, String cname) {
		pkgname = pkgname.replace('.','/');
//		cname = cname.replace('.','/');
		return pkgname + '/' + cname + ".java";
//		return cname.substring(cname.lastIndexOf('.')+1) + ".java";
	}
	
}