/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.program;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class IndependantBPELProgram implements BPELProgram {

	File bpel_file;
	String name;
	
	String base_uri;
	
	SessionAddress coordinator_daemon;
	SessionAddress coordinator;
	ArrayList worker_daemons = new ArrayList();
	ArrayList workers = new ArrayList();

	ArrayList jar_dependencies = new ArrayList();
	
	public IndependantBPELProgram(File file) throws IOException {
		bpel_file = file;
		name = file.getName();
		base_uri = bpel_file.getParentFile().toURL().toString();
	}
	
	public String getName() {
		return name;
	}

	public String getBaseURI() {
		return base_uri;
	}

	public String getBpelSource() throws Exception {
		FileInputStream fin = new FileInputStream(bpel_file);
		String dat = StreamUtils.readAllAsString(new BufferedInputStream(fin));
		fin.close();
		return dat;
	}

	public SessionAddress[] getWorkerDaemons() {
		SessionAddress[] tmp = new SessionAddress[worker_daemons.size()];
		worker_daemons.toArray(tmp);
		return tmp;
	}
	public SessionAddress[] getWorkerHosts() {
		SessionAddress[] tmp = new SessionAddress[workers.size()];
		worker_daemons.toArray(tmp);
		return tmp;
	}
	
	public SessionAddress getCoordinatorHost() {
		return coordinator;
	}
	
	public SessionAddress getCoordinatorDaemon() {
		return coordinator_daemon;
	}
	
	public String[] getProgramDependencies() {
		String[] deps = new String[jar_dependencies.size()];
		jar_dependencies.toArray(deps);
		return deps;
	}

	public void setCoordinatorHost(SessionAddress daemon_address, SessionAddress coordinator_address) {
		this.coordinator_daemon = daemon_address;
		this.coordinator = coordinator_address;
	}

	public void addWorkerHost(SessionAddress daemon_address, SessionAddress worker_address) {
		worker_daemons.add(daemon_address);
		workers.add(worker_address);
	}

	public void addJarDependency(String localJarPath) {
		jar_dependencies.add(localJarPath);
	}
	
}