/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
//import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;

/**
 * 
 * @author amiguel
 *
 * BPEL engine debug target
 */
public class ControllerDebugProcess implements IProcess {

	ControllerInterface engine;
	String engine_name;
	public ILaunch launch;
	public ControllerStreamsProxy streams_proxy;
	
	public ControllerDebugProcess(ILaunch launch, ControllerInterface controller, String engine_name) {
		this.launch = launch;
		this.engine = controller;
		this.engine_name = engine_name;

		streams_proxy = new ControllerStreamsProxy(controller);
	}
	
	public ILaunch getLaunch() {
		return launch;
	}
	
	public IStreamsProxy getStreamsProxy() {
		System.err.println("getStreamsProxy");
		return streams_proxy;
	}
	
	boolean terminated = false;
	
	public boolean canTerminate() {
		return true;
	}

	public boolean isTerminated() {
		return terminated;
	}

	public void terminate() throws DebugException {
		terminated = true;
		try {
			engine.terminate();
		} catch (Exception e) {
			throw new DebugException(new Status(Status.ERROR,B2jPlugin.getDefault().getBundle().getSymbolicName(),DebugException.TARGET_REQUEST_FAILED,"Failed to terminate engine",e));
		}
	}

	public int getExitValue() {
		return 0;
	}

	public String getLabel() {
		return engine_name;
	}

	public void setAttribute(String name, String value) {
		//ignored
	}
	
	public String getAttribute(String name) {
		if (name.equals(IProcess.ATTR_CMDLINE)) {
			return "";
		} else if (name.equals(IProcess.ATTR_PROCESS_LABEL)) {
			return engine_name;
		} else if (name.equals(IProcess.ATTR_PROCESS_TYPE)) {
			return "b2j engine";
		}
		return "";
	}
	
	//
	// UNIMPLEMENTED
	//
	

	/* (non-Javadoc)
	 * @see org.eclipse.core.runtime.IAdaptable#getAdapter(java.lang.Class)
	 */
	public Object getAdapter(Class adapter) {
		// TODO Auto-generated method stub
		return null;
	}
}