/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.io.IOException;
import java.util.ArrayList;

import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.TraceListener;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * proxies controller console info into the debug console
 */
public class ControllerStreamsProxy implements IStreamsProxy {
	
	public ControllerInterface engine;
	ErrorStreamMonitor err_mon;
	StandardStreamMonitor std_mon;
	
	public ControllerStreamsProxy(ControllerInterface cint) {
		this.engine = cint;
		
		err_mon = new ErrorStreamMonitor();
		std_mon = new StandardStreamMonitor();
		
		engine.addTraceListener(err_mon);
		engine.addTraceListener(std_mon);
	}

	public IStreamMonitor getErrorStreamMonitor() {
		return err_mon;
	}

	public IStreamMonitor getOutputStreamMonitor() {
		return std_mon;
	}

	public void write(String input) throws IOException {
		//ignored
		//TODO but this could be very interesting?  could have a debugging interface to the engine?
	}
	
	class ErrorStreamMonitor extends BasicStreamMonitor {

		public void trace(Message m) {}

		public void print(String s) {}

		public void debug(String s) {
			addContent(s);
		}
	}
	class StandardStreamMonitor extends BasicStreamMonitor {

		public void trace(Message m) {}

		public void print(String s) {
			addContent(s);
		}

		public void debug(String s) {}
	}

	abstract class BasicStreamMonitor implements IStreamMonitor, TraceListener {
		Object LOCK = new Object();
		ArrayList listeners = new ArrayList();
		StringBuffer content = new StringBuffer();
		
		public void addListener(IStreamListener listener) {
			synchronized(LOCK) {
				listeners.add(listener);
			}
		}

		protected void addContent(String dat) {
			synchronized(LOCK) {
				content.append(dat);
			}
		}
		
		public String getContents() {
			String str_content;
			synchronized(LOCK) {
				str_content = content.toString();
				content.setLength(0);
			}
			return str_content;
		}

		public void removeListener(IStreamListener listener) {
			synchronized(LOCK) {
				listeners.remove(listener);
			}
		}

		public abstract void trace(Message m);
		public abstract void print(String s);
		public abstract void debug(String s);
	}
}