/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;

public class DebugUtils {
	
	public static void fireEvent(DebugEvent event) {
		DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[] {event});
	}
	
	public static void fireCreationEvent(Object source) {
		fireEvent(new DebugEvent(source, DebugEvent.CREATE));
	}	
	
	public static void fireResumeEvent(Object source, int detail) {
		fireEvent(new DebugEvent(source, DebugEvent.RESUME, detail));
	}

	public static void fireSuspendEvent(Object source, int detail) {
		fireEvent(new DebugEvent(source, DebugEvent.SUSPEND, detail));
	}
	
	public static void fireTerminateEvent(Object source) {
		fireEvent(new DebugEvent(source, DebugEvent.TERMINATE));
	}	
}