/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.ui.internal.debug;

import java.util.ArrayList;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.stp.b2j.core.B2jPlugin;
import org.eclipse.stp.b2j.core.jengine.internal.core.api.ControllerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

/**
 * 
 * @author amiguel
 *
 * BPEL engine debug thread - proxy to an engine Runner
 */
public class RunnerDebugThread extends ControllerDebugElement implements IThread {

	ControllerInterface engine;
	ControllerStackTracker stacks;
	ControllerDebugTarget target;

	String threadId;
	
	IStackFrame[] stackframes = new IStackFrame[0];
	
	public RunnerDebugThread(ControllerDebugTarget target, ControllerInterface engine, ControllerStackTracker stacks, String threadId) {
		super(target);
		this.target = target;
		this.engine = engine;
		this.stacks = stacks;
		this.threadId = threadId;
	}
	
	public String getThreadId() {
		return threadId;
	}
	
	public boolean equals(Object o) {
		if (super.equals(o)) return true;
		if (o instanceof RunnerDebugThread) {
			if (((RunnerDebugThread)o).threadId.equals(threadId)) {
				return true;
			}
		}
		return false;
	}
	
	//
	//IThread implementation
	//
	public String getName() throws DebugException {
		return threadId;
	}

	public boolean hasStackFrames() throws DebugException {
		return getDebugTarget().isSuspended();
		/*
		if (stackframes == null) {
			getStackFrames();
		} else if (stackframes.length == 0) {
			getStackFrames();
		}
		
		if (stackframes == null) {
			return false;
		} else {
			return stackframes.length > 0;
		}*/
	}

	public IStackFrame[] getStackFrames() throws DebugException {
		try {
		System.err.println("GET STACKFRAMES!");
		Message stack = stacks.getStack(threadId);

		if (stack == null) return stackframes;
		
		System.err.println("STACKFRAMES:");
		ArrayList frames = new ArrayList();
		RunnerStackFrame curr_frame = null;
		for (int i = 0; i < stack.length(); i++) {
			Object o = stack.get(i);
			if (o instanceof String) {
				if (curr_frame != null) {
					frames.add(curr_frame);
				}
				curr_frame = new RunnerStackFrame(curr_frame,this,(String)o);
				System.err.println("STACKFRAME:"+curr_frame.getName());
			} else {
				if (curr_frame != null) {
					curr_frame.addFrameMessage((Message)o);
				}
			}
		}
		if (curr_frame != null) {
			frames.add(curr_frame);
		}
		
		
		IStackFrame[] tmp = new IStackFrame[frames.size()];
		frames.toArray(tmp);
		stackframes = tmp;
		
		return stackframes;
	} catch (Throwable t) {
		t.printStackTrace();
		return null;
	}
	}

	public IStackFrame getTopStackFrame() throws DebugException {
		try {
System.err.println("GET TOP STACKFRAME!");
		if (stackframes == null) {
			getStackFrames();
		} else if (stackframes.length == 0) {
			getStackFrames();
		}
		
		if (stackframes.length > 0) {
System.err.println("TOP STACKFRAME: "+stackframes[0]);
			return stackframes[0];
		} else {
System.err.println("TOP STACKFRAME: NULL!");
			return null;
		}
		} catch (Throwable t) {
			t.printStackTrace();
			return null;
		}
	}

	public int getPriority() throws DebugException {
		return 0;
	}

	public IDebugTarget getDebugTarget() {
		return target;
	}

	public ILaunch getLaunch() {
		return getDebugTarget().getLaunch();
	}

	public boolean canResume() {
		return getDebugTarget().canResume();
	}

	public boolean canSuspend() {
		return getDebugTarget().canSuspend();
	}

	public boolean isSuspended() {
		return getDebugTarget().isSuspended();
	}

	public void resume() throws DebugException {
		getDebugTarget().resume();
	}

	public void suspend() throws DebugException {
		getDebugTarget().suspend();
	}
	
	public String getModelIdentifier() {
		return B2jPlugin.DEBUG_MODEL_ID;
	}


	public boolean canTerminate() {
		return getDebugTarget().canTerminate();
	}

	public boolean isTerminated() {
		return getDebugTarget().isTerminated();
	}

	public void terminate() throws DebugException {
		getDebugTarget().terminate();
	}
	
	public Object getAdapter(Class adapter) {
		if (adapter == getClass()) {
			return this;
		}
		return super.getAdapter(adapter);
	}

	//
	//Unimplemented
	//
	
	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IThread#getBreakpoints()
	 */
	public IBreakpoint[] getBreakpoints() {
		// TODO Auto-generated method stub
		return new IBreakpoint[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepInto()
	 */
	public boolean canStepInto() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepOver()
	 */
	public boolean canStepOver() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#canStepReturn()
	 */
	public boolean canStepReturn() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#isStepping()
	 */
	public boolean isStepping() {
		// TODO Auto-generated method stub
		return false;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepInto()
	 */
	public void stepInto() throws DebugException {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepOver()
	 */
	public void stepOver() throws DebugException {
		// TODO Auto-generated method stub
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.IStep#stepReturn()
	 */
	public void stepReturn() throws DebugException {
		// TODO Auto-generated method stub
		
	}
}