/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.AddCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ToggleCanonicalModeCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.actions.AbstractGroupUngroupAction;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UngroupAction
extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "ungroupAction";
    public static final String TOOLBAR_ACTION_ID = "toolbarUngroupAction";
    private static final String ICON_PATH = "icons/Ungroup.gif";
    private static final String ACTION_TEXT = "Ungroup";
    private static final String TOOLTIP_TEXT = "Ungroup Shapes(Remove Sub-Process)";
    private List<SubProcessEditPart> subProcesses = new ArrayList<SubProcessEditPart>();

    public UngroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public UngroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static UngroupAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        UngroupAction action = new UngroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        BpmnDiagramEditorPlugin.getInstance();
        action.setImageDescriptor(BpmnDiagramEditorPlugin.findImageDescriptor(ICON_PATH));
        return action;
    }

    public static UngroupAction createUngroupAction(IWorkbenchPage workbenchPage) {
        UngroupAction action = UngroupAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);
        return action;
    }

    public static UngroupAction createToolbarUngroupAction(IWorkbenchPage workbenchPage) {
        UngroupAction action = UngroupAction.createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        CompositeCommand cc = new CompositeCommand(ACTION_TEXT);
        for (SubProcessEditPart subProcess : this.subProcesses) {
            cc.compose((IUndoableOperation)UngroupAction.getUngroupCommand(subProcess));
        }
        SubProcessEditPart first = this.subProcesses.get(0);
        first.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)cc));
    }

    public static ICommand getUngroupCommand(SubProcessEditPart subProcessEditPart) {
        ConnectionEditPart connection;
        List connections;
        List childrenToUngroup = subProcessEditPart.getChildBySemanticHint(Integer.toString(5002)).getChildren();
        if (childrenToUngroup.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeCommand cc = new CompositeCommand("Ungroup commands for signle sub-process");
        EditPart containerEditPart = subProcessEditPart.getParent();
        View container = (View)containerEditPart.getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        ToggleCanonicalModeCommand containerCanonicalModeCommand = new ToggleCanonicalModeCommand(containerEditPart, false);
        cc.compose((IUndoableOperation)new CommandProxy((Command)containerCanonicalModeCommand));
        ToggleCanonicalModeCommand subProcessCanonicalModeCommand = new ToggleCanonicalModeCommand((EditPart)subProcessEditPart, false);
        cc.compose((IUndoableOperation)new CommandProxy((Command)subProcessCanonicalModeCommand));
        for (Object object : childrenToUngroup) {
            IGraphicalEditPart gep = (IGraphicalEditPart)object;
            cc.compose((IUndoableOperation)UngroupAction.getReparentUngroupCommand(subProcessEditPart, gep));
        }
        HashSet<SequenceEdgeEditPart> innerConnections = new HashSet<SequenceEdgeEditPart>();
        for (Object part : childrenToUngroup) {
            IGraphicalEditPart gep = (IGraphicalEditPart)part;
            List connections2 = gep.getSourceConnections();
            for (Object connection2 : connections2) {
                if (!(connection2 instanceof SequenceEdgeEditPart)) continue;
                innerConnections.add((SequenceEdgeEditPart)((Object)connection2));
            }
            connections2 = gep.getTargetConnections();
            for (Object connection2 : connections2) {
                if (!(connection2 instanceof SequenceEdgeEditPart)) continue;
                innerConnections.add((SequenceEdgeEditPart)((Object)connection2));
            }
        }
        UngroupAction.reparentInnnerConnections(innerConnections, subProcessEditPart.getEditingDomain(), context, cc);
        ArrayList<IGraphicalEditPart> startElements = new ArrayList<IGraphicalEditPart>();
        ArrayList<IGraphicalEditPart> endElements = new ArrayList<IGraphicalEditPart>();
        UngroupAction.getStartAndEndTasks(subProcessEditPart, startElements, endElements);
        if (startElements.size() == 1) {
            connections = subProcessEditPart.getSourceConnections();
            int idx = 0;
            int size = connections.size();
            for (Object object : connections) {
                connection = (ConnectionEditPart)object;
                cc.compose((IUndoableOperation)UngroupAction.getReconnectSourceCommand(connection, (ShapeNodeEditPart)startElements.get(0), idx, size));
                ++idx;
            }
        }
        if (endElements.size() == 1) {
            connections = subProcessEditPart.getTargetConnections();
            int idx = 0;
            int size = connections.size();
            for (Object object : connections) {
                connection = (ConnectionEditPart)object;
                cc.compose((IUndoableOperation)UngroupAction.getReconnectTargetCommand(connection, (ShapeNodeEditPart)endElements.get(0), idx, size));
                ++idx;
            }
        }
        View model = (View)subProcessEditPart.getModel();
        EObject elementToDestroy = ViewUtil.resolveSemanticElement((View)model);
        DestroyElementRequest destroyRequest = new DestroyElementRequest(subProcessEditPart.getEditingDomain(), elementToDestroy, false);
        DestroyElementCommand destoryCommand = new DestroyElementCommand(destroyRequest);
        cc.compose((IUndoableOperation)new CommandProxy((Command)ToggleCanonicalModeCommand.getToggleCanonicalModeCommand((ToggleCanonicalModeCommand)subProcessCanonicalModeCommand, (boolean)true)));
        DeleteCommand deleteViewCommand = new DeleteCommand(subProcessEditPart.getEditingDomain(), model);
        cc.compose((IUndoableOperation)deleteViewCommand);
        cc.compose((IUndoableOperation)destoryCommand);
        cc.compose((IUndoableOperation)new CommandProxy((Command)ToggleCanonicalModeCommand.getToggleCanonicalModeCommand((ToggleCanonicalModeCommand)containerCanonicalModeCommand, (boolean)true)));
        return cc;
    }

    private static ICommand getReparentUngroupCommand(SubProcessEditPart subProcessEditPart, IGraphicalEditPart childEditPart) {
        CompositeCommand cc = new CompositeCommand("Ungroup commands for single child edit part");
        EditPart containerEditPart = subProcessEditPart.getParent();
        View container = (View)containerEditPart.getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)childEditPart.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = childEditPart.getEditingDomain();
        if (element != null) {
            MoveElementsCommand moveSemanticCmd = new MoveElementsCommand(new MoveRequest(editingDomain, context, element));
            if (moveSemanticCmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)UngroupAction.getReparentViewCommand(childEditPart, containerEditPart));
            cc.compose((IUndoableOperation)moveSemanticCmd);
            IFigure figure = childEditPart.getFigure();
            Rectangle newBounds = figure.getBounds();
            figure.translateToAbsolute((Translatable)newBounds);
            IGraphicalEditPart parentContainerEditPart = (IGraphicalEditPart)childEditPart.getParent().getParent();
            parentContainerEditPart.getFigure().translateToRelative((Translatable)newBounds);
            SetBoundsCommand setBounsCommand = new SetBoundsCommand(childEditPart.getEditingDomain(), "Update bounds", (IAdaptable)childEditPart, newBounds);
            cc.compose((IUndoableOperation)setBounsCommand);
        }
        return cc;
    }

    private static ICommand getReparentViewCommand(IGraphicalEditPart childEditPart, EditPart newContainerEditPart) {
        View container = (View)newContainerEditPart.getModel();
        View view = (View)childEditPart.getModel();
        return new AddCommand(childEditPart.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)container), (IAdaptable)new EObjectAdapter((EObject)view));
    }

    private static void getStartAndEndTasks(SubProcessEditPart subProcessEditPart, List<IGraphicalEditPart> startElements, List<IGraphicalEditPart> endElements) {
        List children = subProcessEditPart.getChildBySemanticHint(Integer.toString(5002)).getChildren();
        for (Object object : children) {
            IGraphicalEditPart editPart = (IGraphicalEditPart)object;
            List sourceConnections = editPart.getSourceConnections();
            boolean noConnections = true;
            if (!sourceConnections.isEmpty()) {
                for (Object connection : sourceConnections) {
                    if (!(connection instanceof SequenceEdgeEditPart)) continue;
                    noConnections = false;
                    break;
                }
            }
            if (noConnections) {
                startElements.add(editPart);
            }
            List targetConnections = editPart.getTargetConnections();
            noConnections = true;
            if (!targetConnections.isEmpty()) {
                for (Object connection : targetConnections) {
                    if (!(connection instanceof SequenceEdgeEditPart)) continue;
                    noConnections = false;
                    break;
                }
            }
            if (!noConnections) continue;
            endElements.add(editPart);
        }
    }

    public void refresh() {
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        this.subProcesses.clear();
        if (structuredSelection != null) {
            for (Object selElement : structuredSelection) {
                EditPart editPart;
                SubProcessEditPart subProcess;
                if (!(selElement instanceof ShapeNodeEditPart) || (subProcess = UngroupAction.getSubProcess(editPart = (EditPart)selElement)) == null || this.subProcesses.contains((Object)subProcess)) continue;
                this.subProcesses.add(subProcess);
            }
            this.subProcesses = ToolUtilities.getSelectionWithoutDependants(this.subProcesses);
        }
        this.setEnabled(!this.subProcesses.isEmpty());
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }
}

