/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.SubProcessItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.SubProcessBodyFigure;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.DefaultSizeNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.DelegateToCompartmentEditPolicy;
import org.eclipse.stp.bpmn.policies.GenericEAnnotationDropPolicy;
import org.eclipse.stp.bpmn.policies.ResizableSubProcessEditPolicy;
import org.eclipse.stp.bpmn.tools.AddChildLayoutListener;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

public class SubProcessEditPart
extends ShapeNodeEditPart {
    public static final Dimension COLLAPSED_SIZE = new Dimension(111, 81);
    public static final Dimension EXPANDED_SIZE = new Dimension(131, 124);
    public static final int VISUAL_ID = 2002;
    protected boolean needToUpdateContainer;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private static final int MIN_BODY_WIDTH = 50;
    private static final int MIN_BODY_HEIGHT = 50;
    private static final Insets INSETS = new Insets(5, 5, 5, 5);

    public SubProcessEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new CreationEditPolicy(){

            public Command getCommand(Request request) {
                if (this.understandsRequest(request)) {
                    CreateElementRequestAdapter adapter;
                    IElementType type;
                    if (request instanceof CreateViewAndElementRequest && (type = (IElementType)(adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter()).getAdapter(IElementType.class)) == BpmnElementTypes.Activity_2003) {
                        IGraphicalEditPart compartmentEditPart = SubProcessEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(5003));
                        return compartmentEditPart == null ? null : compartmentEditPart.getCommand(request);
                    }
                    return super.getCommand(request);
                }
                return null;
            }
        });
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SubProcessItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SubProcessGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new SubProcessCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("CreationPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ConnectionHandleEditPolicyEx());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new GenericEAnnotationDropPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new DelegateToCompartmentEditPolicy(BpmnVisualIDRegistry.getType(5002), "ContainerEditPolicy"));
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        SubProcessFigure figure = new SubProcessFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public SubProcessFigure getPrimaryShape() {
        return (SubProcessFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessNameEditPart) {
            ((SubProcessNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureSubProcessNameFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            SubProcessBodyFigure pane = this.getPrimaryShape().getFigureSubProcessBodyFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((SubProcessSubProcessBodyCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            SubProcessBorderFigure pane = this.getPrimaryShape().getFigureSubProcessBorderFigure();
            this.setupContentPane((IFigure)pane);
            pane.add(((SubProcessSubProcessBorderCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            SubProcessBodyFigure pane = this.getPrimaryShape().getFigureSubProcessBodyFigure();
            pane.remove(((SubProcessSubProcessBodyCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            SubProcessBorderFigure pane = this.getPrimaryShape().getFigureSubProcessBorderFigure();
            pane.remove(((SubProcessSubProcessBorderCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected NodeFigure createNodePlate() {
        return new DefaultSizeNodeFigureEx(this.getMapMode().DPtoLP(SubProcessEditPart.EXPANDED_SIZE.width), this.getMapMode().DPtoLP(SubProcessEditPart.EXPANDED_SIZE.height), ConnectionAnchorFactory.INSTANCE){

            public Rectangle getHandleBounds() {
                SubProcessFigure figure = SubProcessEditPart.this.getPrimaryShape();
                return figure.getVisibleBounds();
            }

            public void setBounds(Rectangle rect) {
                boolean translate;
                int x = this.bounds.x;
                int y = this.bounds.y;
                boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
                boolean bl = translate = rect.x != x || rect.y != y;
                if ((resize || translate) && this.isVisible()) {
                    this.erase();
                }
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    this.primTranslate(dx, dy);
                }
                this.bounds.width = rect.width;
                this.bounds.height = rect.height;
                if (translate || resize) {
                    if (resize || SubProcessEditPart.this.needToUpdateContainer && translate) {
                        this.invalidate();
                    }
                    this.fireFigureMoved();
                    this.repaint();
                }
            }
        };
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        figure.addLayoutListener((LayoutListener)new AddChildLayoutListener((EditPart)this));
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(0);
            nodeShape.setLayoutManager((LayoutManager)layout);
            nodeShape.setBorder(null);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4003));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    public Dimension calcMinSize() {
        Rectangle r1;
        List children = this.getChildren();
        GraphicalEditPart bodyEditPart = null;
        GraphicalEditPart borderEditPart = null;
        GraphicalEditPart nameEditPart = null;
        for (Object object : children) {
            GraphicalEditPart editPart = (GraphicalEditPart)object;
            if (editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                bodyEditPart = editPart;
                continue;
            }
            if (editPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
                borderEditPart = editPart;
                continue;
            }
            if (!(editPart instanceof SubProcessNameEditPart)) continue;
            nameEditPart = editPart;
        }
        Dimension labelSize = nameEditPart.getFigure().getSize();
        boolean isCollapsed = (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
        if (!isCollapsed) {
            r1 = SubProcessEditPart.getChildrenBounds((EditPart)bodyEditPart);
            if (r1.height == 0) {
                r1.width = 50;
                r1.height = 50;
            }
        } else {
            r1 = new Rectangle(0, 0, 50, 50);
        }
        Rectangle r2 = SubProcessEditPart.getChildrenBounds((EditPart)borderEditPart);
        if (r2.height == 0) {
            r2.height = borderEditPart.getFigure().getBounds().height;
        }
        return new Dimension(Math.max(r1.width, r2.width) + INSETS.getWidth(), labelSize.height + r1.height + INSETS.getHeight() + r2.height);
    }

    private static Rectangle getChildrenBounds(EditPart editPart) {
        Rectangle r = new Rectangle();
        List children = editPart.getChildren();
        boolean isFirst = true;
        for (Object object : children) {
            GraphicalEditPart child = (GraphicalEditPart)object;
            if (!isFirst) {
                r.union(child.getFigure().getBounds());
                continue;
            }
            r = child.getFigure().getBounds().getCopy();
            isFirst = false;
        }
        return r;
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableSubProcessEditPolicy();
    }

    protected void refreshBounds() {
        super.refreshBounds();
        this.refreshChildrenLocation();
    }

    private void refreshChildrenLocation() {
        boolean isCollapsed;
        List children = this.getChildren();
        GraphicalEditPart bodyEditPart = null;
        GraphicalEditPart borderEditPart = null;
        GraphicalEditPart nameEditPart = null;
        for (Object object : children) {
            GraphicalEditPart editPart = (GraphicalEditPart)object;
            if (editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
                bodyEditPart = editPart;
                continue;
            }
            if (editPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
                borderEditPart = editPart;
                continue;
            }
            if (!(editPart instanceof SubProcessNameEditPart)) continue;
            nameEditPart = editPart;
        }
        if (bodyEditPart != null && !(isCollapsed = ((Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed())).booleanValue())) {
            int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            int totalHeight = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
            int borderCompartmentHeight = borderEditPart.getFigure().getSize().height;
            int labelHeight = nameEditPart.getFigure().getSize().height;
            int height = totalHeight - borderCompartmentHeight - labelHeight;
            Point moveDelta = new Point(0, 0);
            bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
            Rectangle rect = SubProcessEditPart.getChildrenBounds((EditPart)bodyEditPart);
            if (rect.x + rect.width > width - INSETS.getWidth()) {
                moveDelta.x = rect.x + rect.width - (width - INSETS.getWidth());
            }
            if (rect.y + rect.height > height - INSETS.getHeight()) {
                moveDelta.y = rect.y + rect.height - (height - INSETS.getHeight());
            }
            children = bodyEditPart.getChildren();
            if (moveDelta.x + moveDelta.y > 0 && children.size() > 0) {
                CompositeCommand command = new CompositeCommand("Move subprocess' children");
                int i = 0;
                while (i < children.size()) {
                    GraphicalEditPart part = (GraphicalEditPart)children.get(i);
                    Rectangle bound = part.getFigure().getBounds();
                    Point loc = new Point(bound.x - moveDelta.x, bound.y - moveDelta.y);
                    Rectangle newBounds = new Rectangle(loc, bound.getSize());
                    SetBoundsCommand cmd = new SetBoundsCommand(this.getEditingDomain(), "Set bounds", (IAdaptable)part, newBounds);
                    command.add((IUndoableOperation)cmd);
                    ++i;
                }
                try {
                    command.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Rectangle getAbsBoundsWithoutBorder() {
        boolean hasChildren = false;
        for (Object child : this.children) {
            if (!(child instanceof SubProcessSubProcessBorderCompartmentEditPart)) continue;
            hasChildren = ((EditPart)child).getChildren().size() > 0;
            break;
        }
        SubProcessFigure figure = this.getPrimaryShape();
        Rectangle theBounds = figure.getVisibleBounds();
        if (hasChildren) {
            int delta = SubProcessBorderFigure.getFixedHeightDP((IFigure)figure) / 2;
            theBounds.height -= delta;
        }
        figure.translateToAbsolute((Translatable)theBounds);
        return theBounds;
    }

    public Rectangle getAbsCollapseHandleBounds() {
        double size = 20.0;
        RootEditPart rootEditPart = this.getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            double zoom = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager().getZoom();
            size *= zoom;
        }
        Rectangle theBounds = this.getAbsBoundsWithoutBorder();
        PrecisionRectangle handleBounds = new PrecisionRectangle(theBounds);
        handleBounds.setX((double)handleBounds.x + ((double)handleBounds.width - size) / 2.0);
        handleBounds.setY((double)(handleBounds.y + handleBounds.height) - size);
        handleBounds.setWidth(size);
        handleBounds.setHeight(size);
        SubProcess model = (SubProcess)((View)this.getModel()).getElement();
        if (model.isLooping()) {
            handleBounds.setX((double)handleBounds.x + size / 2.0 + 1.0);
        }
        return handleBounds;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 && BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
            this.figure.repaint();
        }
        super.handleNotificationEvent(notification);
    }

    public boolean isNeedToUpdateContainer() {
        return this.needToUpdateContainer;
    }

    public void setNeedToUpdateContainer(boolean isChildAdded) {
        this.needToUpdateContainer = isChildAdded;
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((EditPart)this);
    }

    public Command getCommand(Request _request) {
        Object model;
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest && (model = ((CreateUnspecifiedTypeConnectionRequest)_request).getTargetEditPart().getModel()) instanceof Node) {
            List elTypes = ((CreateUnspecifiedTypeConnectionRequest)_request).getElementTypes();
            MetamodelType connType = (MetamodelType)BpmnElementTypes.MessagingEdge_3002;
            int i = 0;
            while (i < elTypes.size()) {
                if (elTypes.get(i) instanceof MetamodelType) {
                    connType = (MetamodelType)elTypes.get(i);
                    break;
                }
                ++i;
            }
            if (connType == BpmnElementTypes.MessagingEdge_3002) {
                return null;
            }
            if (connType == BpmnElementTypes.SequenceEdge_3001) {
                CreateUnspecifiedTypeConnectionRequest request;
                EdgeConnectionValidator edgeValidator = new EdgeConnectionValidator();
                if (_request instanceof CreateUnspecifiedTypeConnectionRequest && !(request = (CreateUnspecifiedTypeConnectionRequest)_request).isDirectionReversed() && request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                    for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                        if (connectionRequest.getSourceEditPart() == null || connectionRequest.getTargetEditPart() == null || connectionRequest.getSourceEditPart() != request.getSourceEditPart() || connectionRequest.getTargetEditPart() != request.getTargetEditPart() || edgeValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart())) continue;
                        return null;
                    }
                }
            }
        }
        return super.getCommand(_request);
    }

    public class SubProcessFigure
    extends org.eclipse.stp.bpmn.figures.SubProcessFigure {
        private WrapLabel fSubProcessNameFigure;
        private SubProcessBodyFigure fSubProcessBodyFigure;
        private SubProcessBorderFigure fSubProcessBorderFigure;
        private boolean myUseLocalCoordinates = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !SubProcessFigure.class.desiredAssertionStatus();
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            return new Dimension(100, 100);
        }

        public SubProcessFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            WrapLabel fig_0 = new WrapLabel();
            fig_0.setText("");
            this.setFigureSubProcessNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
            SubProcessBodyFigure fig_1 = new SubProcessBodyFigure(){};
            this.setFigureSubProcessBodyFigure(fig_1);
            Object layData1 = null;
            this.add((IFigure)fig_1, layData1);
            SubProcessBorderFigure fig_2 = new SubProcessBorderFigure(SubProcessEditPart.this.getMapMode());
            this.setFigureSubProcessBorderFigure(fig_2);
            Object layData2 = null;
            this.add((IFigure)fig_2, layData2);
        }

        public WrapLabel getFigureSubProcessNameFigure() {
            return this.fSubProcessNameFigure;
        }

        private void setFigureSubProcessNameFigure(WrapLabel fig) {
            this.fSubProcessNameFigure = fig;
        }

        public SubProcessBodyFigure getFigureSubProcessBodyFigure() {
            return this.fSubProcessBodyFigure;
        }

        private void setFigureSubProcessBodyFigure(SubProcessBodyFigure fig) {
            this.fSubProcessBodyFigure = fig;
        }

        public SubProcessBorderFigure getFigureSubProcessBorderFigure() {
            return this.fSubProcessBorderFigure;
        }

        private void setFigureSubProcessBorderFigure(SubProcessBorderFigure fig) {
            this.fSubProcessBorderFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            SubProcess model = (SubProcess)((View)SubProcessEditPart.this.getModel()).getElement();
            if (model.isLooping()) {
                Rectangle bounds = SubProcessEditPart.this.getAbsBoundsWithoutBorder();
                this.translateToRelative((Translatable)bounds);
                PrecisionRectangle loopRect = ActivityPainter.getLoopMarkerBounds(bounds);
                loopRect.setX(loopRect.preciseX - loopRect.preciseWidth / 2.0 - 1.0);
                ActivityPainter.paintLoop(graphics, loopRect, (IFigure)this);
            }
            this.paintCollapseHandle(graphics);
        }

        private void paintCollapseHandle(Graphics graphics) {
            Rectangle bounds = SubProcessEditPart.this.getAbsCollapseHandleBounds();
            this.translateToRelative((Translatable)bounds);
            int lineWidth = 1;
            bounds.shrink(lineWidth, lineWidth);
            graphics.drawRectangle(bounds);
            graphics.setLineWidth(lineWidth *= 2);
            double delta = lineWidth;
            double y = (double)bounds.y + (double)bounds.height / 2.0;
            PrecisionPoint p1 = new PrecisionPoint((double)bounds.x + delta, y);
            PrecisionPoint p2 = new PrecisionPoint((double)(bounds.x + bounds.width) - delta, y);
            graphics.drawLine((Point)p1, (Point)p2);
            GraphicalEditPart bodyEditPart = null;
            for (Object object : ((AbstractEditPart)SubProcessEditPart.this).children) {
                if (!(object instanceof SubProcessSubProcessBodyCompartmentEditPart)) continue;
                bodyEditPart = (GraphicalEditPart)object;
                break;
            }
            if (!$assertionsDisabled && bodyEditPart == null) {
                throw new AssertionError();
            }
            boolean isCollapsed = (Boolean)bodyEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed());
            if (isCollapsed) {
                double x = (double)bounds.x + (double)bounds.width / 2.0;
                p1 = new PrecisionPoint(x, (double)bounds.y + delta);
                p2 = new PrecisionPoint(x, (double)(bounds.y + bounds.height) - delta);
                graphics.drawLine((Point)p1, (Point)p2);
            }
        }
    }
}

