/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.commands.IElementTypeEx;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNElementTypesActivities {
    private static Collection<IElementTypeEx> TypesForSubProcessBorder;
    private static Collection<IElementTypeEx> TypesForPoolAndSubProcessBody;
    private static Collection<IElementTypeEx> TypesForSequenceEdgeSource;
    private static Collection<IElementTypeEx> TypesForSequenceEdgeTarget;
    private static Collection<IElementTypeEx> TypesForMessagingEdgeSource;
    private static Collection<IElementTypeEx> TypesForMessagingEdgeTarget;

    public static Collection<IElementTypeEx> getElementTypesForSubProcessBorder() {
        if (TypesForSubProcessBorder == null) {
            TypesForSubProcessBorder = Collections.unmodifiableCollection((Collection)Arrays.asList(ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_COMPENSATION_LITERAL.getLiteral()), ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_ERROR_LITERAL.getLiteral()), ElementTypeEx.wrap(BpmnElementTypes.Activity_2003, ActivityType.EVENT_INTERMEDIATE_TIMER_LITERAL.getLiteral())));
        }
        return TypesForSubProcessBorder;
    }

    public static Collection<IElementTypeEx> getElementTypesForPoolAndSubProcessBody() {
        if (TypesForPoolAndSubProcessBody == null) {
            TypesForPoolAndSubProcessBody = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                String literal = ((ActivityType)at).getLiteral();
                IElementType elementType = "SubProcess".equals(literal) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(elementType, literal));
            }
            TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
            TypesForPoolAndSubProcessBody.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
        }
        return TypesForPoolAndSubProcessBody;
    }

    public static Collection<IElementTypeEx> getElementTypesForSequenceEdgeSource() {
        if (TypesForSequenceEdgeSource == null) {
            TypesForSequenceEdgeSource = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String literal = attype.getLiteral();
                if (literal.startsWith("EventEnd")) continue;
                IElementType elementType = "SubProcess".equals(literal) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(elementType, literal));
            }
            TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
            TypesForSequenceEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
        }
        return TypesForSequenceEdgeSource;
    }

    public static Collection<IElementTypeEx> getElementTypesForSequenceEdgeTarget() {
        if (TypesForSequenceEdgeTarget == null) {
            TypesForSequenceEdgeTarget = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String literal = attype.getLiteral();
                if (literal.startsWith("EventStart")) continue;
                IElementType elementType = "SubProcess".equals(literal) ? BpmnElementTypes.SubProcess_2002 : BpmnElementTypes.Activity_2001;
                TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(elementType, literal));
            }
            TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
            TypesForSequenceEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.SubProcess_2002, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
        }
        return TypesForSequenceEdgeTarget;
    }

    public static Collection<IElementTypeEx> getElementTypesForMessagingEdgeTarget() {
        if (TypesForMessagingEdgeTarget == null) {
            TypesForMessagingEdgeTarget = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String literal = attype.getLiteral();
                if (literal.startsWith("Gateway")) continue;
                switch (attype.getValue()) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 11: 
                    case 15: {
                        break;
                    }
                    default: {
                        TypesForMessagingEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, literal));
                    }
                }
            }
            TypesForMessagingEdgeTarget.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
        }
        return TypesForMessagingEdgeTarget;
    }

    public static Collection<IElementTypeEx> getElementTypesForMessagingEdgeSource() {
        if (TypesForMessagingEdgeSource == null) {
            TypesForMessagingEdgeSource = new ArrayList<IElementTypeEx>();
            for (Object at : ActivityType.VALUES) {
                ActivityType attype = (ActivityType)at;
                String literal = attype.getLiteral();
                if (literal.startsWith("Gateway")) continue;
                switch (attype.getValue()) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 11: 
                    case 15: {
                        break;
                    }
                    default: {
                        TypesForMessagingEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, literal));
                    }
                }
            }
            TypesForMessagingEdgeSource.add(ElementTypeEx.wrap(BpmnElementTypes.Activity_2001, BpmnPackage.Literals.ACTIVITY__LOOPING.getName()));
        }
        return TypesForMessagingEdgeSource;
    }
}

