/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditor;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.dnd.IEAnnotationDecorator;
import org.eclipse.swt.graphics.Image;

public class BpmnEAnnotationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final String KEY = "eannotationdecoration";

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            View view;
            Object model = editPart.getModel();
            if (model instanceof View && !((view = (View)model) instanceof Edge) && !view.isSetElement()) {
                return;
            }
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (((DiagramEditDomain)ed).getEditorPart() instanceof BpmnDiagramEditor) {
                decoratorTarget.installDecorator((Object)KEY, (IDecorator)new EAnnotationDecorator(decoratorTarget));
            }
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        View view = (View)decoratorTarget.getAdapter(View.class);
        return view != null && BpmnDiagramEditPart.MODEL_ID.equals(BpmnVisualIDRegistry.getModelID(view));
    }

    public class EAnnotationDecorator
    implements IDecorator {
        private DecorationEditPolicy.DecoratorTarget decoratorTarget;
        private List<IDecoration> decorations = new ArrayList<IDecoration>();
        private Adapter refreshListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(EModelElement.class) == 0) {
                    EAnnotationDecorator.this.refresh();
                }
            }
        };

        public EAnnotationDecorator(IDecoratorTarget decoratorTarget) {
            this.decoratorTarget = (DecorationEditPolicy.DecoratorTarget)decoratorTarget;
        }

        public void activate() {
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                view.getElement().eAdapters().add((Object)this.refreshListener);
            }
        }

        public void refresh() {
            this.removeDecorations();
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            EditPart editPart = (EditPart)this.decoratorTarget.getAdapter(EditPart.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                EModelElement elt = (EModelElement)view.getElement();
                int offset = -1;
                for (Object objAnn : elt.getEAnnotations()) {
                    EAnnotation ann = (EAnnotation)objAnn;
                    if (!(editPart instanceof GraphicalEditPart)) continue;
                    Image image = this.getImage(editPart, elt, ann);
                    if (image == null) {
                        return;
                    }
                    if (view instanceof Edge) {
                        this.setLastDecoration(this.decoratorTarget.addConnectionDecoration(image, 55 + 7 * elt.getEAnnotations().indexOf((Object)ann), false));
                    } else {
                        IFigure parentFigure = ((GraphicalEditPart)this.decoratorTarget.getAdapter(GraphicalEditPart.class)).getFigure();
                        ImageFigure figure = new ImageFigure(image);
                        figure.setParent(parentFigure);
                        figure.setSize(image.getBounds().width, image.getBounds().height);
                        IDecoration deco = this.decoratorTarget.addDecoration((IFigure)figure, (Locator)new StickyToBorderLocator(parentFigure, this.getPositionConstant(this.getDirection(editPart, elt, ann)), offset), false);
                        offset = offset - image.getBounds().width - 1;
                        this.setLastDecoration(deco);
                    }
                    ((IFigure)this.getLastDecoration()).setToolTip(this.getToolTip(editPart, elt, ann));
                }
            }
        }

        private int getPositionConstant(IDecoratorTarget.Direction direction) {
            if (direction == IDecoratorTarget.Direction.CENTER) {
                return 2;
            }
            if (direction == IDecoratorTarget.Direction.NORTH) {
                return 1;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH) {
                return 4;
            }
            if (direction == IDecoratorTarget.Direction.WEST) {
                return 8;
            }
            if (direction == IDecoratorTarget.Direction.EAST) {
                return 16;
            }
            if (direction == IDecoratorTarget.Direction.NORTH_EAST) {
                return 17;
            }
            if (direction == IDecoratorTarget.Direction.NORTH_WEST) {
                return 9;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH_EAST) {
                return 20;
            }
            if (direction == IDecoratorTarget.Direction.SOUTH_WEST) {
                return 12;
            }
            return 2;
        }

        private IDecoration getLastDecoration() {
            if (!this.decorations.isEmpty()) {
                return this.decorations.get(this.decorations.size() - 1);
            }
            return null;
        }

        private void removeDecorations() {
            for (IDecoration deco : this.decorations) {
                if (deco == null || ((IFigure)deco).getParent() == null) continue;
                this.decoratorTarget.removeDecoration(deco);
            }
        }

        private void setLastDecoration(IDecoration deco) {
            this.decorations.add(deco);
        }

        private IDecoratorTarget.Direction getDirection(EditPart part, EModelElement elt, EAnnotation ann) {
            IEAnnotationDecorator decorator = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDecorator(ann.getSource());
            if (decorator != null) {
                return decorator.getDirection(part, elt, ann);
            }
            return IDecoratorTarget.Direction.NORTH_EAST;
        }

        private Image getImage(EditPart part, EModelElement elt, EAnnotation ann) {
            IEAnnotationDecorator decorator = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDecorator(ann.getSource());
            if (decorator != null) {
                return decorator.getImage(part, elt, ann);
            }
            return null;
        }

        private IFigure getToolTip(EditPart part, EModelElement elt, EAnnotation ann) {
            IEAnnotationDecorator decorator = BpmnDiagramEditorPlugin.getInstance().getEAnnotationDecorator(ann.getSource());
            if (decorator != null) {
                return decorator.getToolTip(part, elt, ann);
            }
            return null;
        }

        public void deactivate() {
            this.removeDecorations();
            View view = (View)this.decoratorTarget.getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            if (view.getElement() instanceof EModelElement) {
                view.getElement().eAdapters().remove((Object)this.refreshListener);
            }
        }
    }

    private class StickyToBorderLocator
    implements Locator {
        private static final int OTHER_DECORATION = 16;
        private int offset;
        protected int direction;
        protected IFigure reference;

        public StickyToBorderLocator(IFigure reference, int direction, int offset) {
            this.reference = reference;
            this.direction = direction;
            this.offset = offset;
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds().getCopy() : this.reference.getBounds().getCopy();
            this.reference.translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            int width = target.getBounds().width;
            int halfWidth = width / 2;
            int height = target.getBounds().height;
            int halfHeight = height / 2;
            if (this.direction == 2) {
                Dimension shift = new Dimension(-halfWidth, -halfHeight);
                target.setLocation(bounds.getCenter().getTranslated(shift));
            } else if (this.offset < 0) {
                if (this.direction == 9) {
                    Dimension shift = new Dimension(-this.offset + 16, 0);
                    target.setLocation(bounds.getTopLeft().getTranslated(shift));
                } else if (this.direction == 1) {
                    Dimension shift = new Dimension(-this.offset, -halfWidth);
                    target.setLocation(bounds.getTop().getTranslated(shift));
                } else if (this.direction == 17) {
                    Dimension shift = new Dimension(-(width + -this.offset), 0);
                    target.setLocation(bounds.getTopRight().getTranslated(shift));
                } else if (this.direction == 12) {
                    Dimension shift = new Dimension(0, -(height + -this.offset));
                    target.setLocation(bounds.getBottomLeft().getTranslated(shift));
                } else if (this.direction == 4) {
                    Dimension shift = new Dimension(-halfWidth, -(height + -this.offset));
                    target.setLocation(bounds.getBottom().getTranslated(shift));
                } else if (this.direction == 20) {
                    Dimension shift = new Dimension(-(width + -this.offset), -height);
                    target.setLocation(bounds.getBottomRight().getTranslated(shift));
                } else if (this.direction == 8) {
                    Dimension shift = new Dimension(-this.offset, -halfHeight);
                    target.setLocation(bounds.getLeft().getTranslated(shift));
                } else if (this.direction == 16) {
                    Dimension shift = new Dimension(-(width + -this.offset), -halfHeight);
                    target.setLocation(bounds.getRight().getTranslated(shift));
                }
            } else if (this.direction == 9) {
                Dimension shift = new Dimension(this.offset, 0);
                target.setLocation(bounds.getTopLeft().getTranslated(shift));
            } else if (this.direction == 1) {
                Dimension shift = new Dimension(-halfWidth, -(height + this.offset));
                target.setLocation(bounds.getTop().getTranslated(shift));
            } else if (this.direction == 17) {
                Dimension shift = new Dimension(0, -(height + this.offset));
                target.setLocation(bounds.getTopRight().getTranslated(shift));
            } else if (this.direction == 12) {
                Dimension shift = new Dimension(-(width + this.offset), 0);
                target.setLocation(bounds.getBottomLeft().getTranslated(shift));
            } else if (this.direction == 4) {
                Dimension shift = new Dimension(-halfWidth, 0);
                target.setLocation(bounds.getBottom().getTranslated(shift));
            } else if (this.direction == 20) {
                Dimension shift = new Dimension(this.offset, 0);
                target.setLocation(bounds.getBottomRight().getTranslated(shift));
            } else if (this.direction == 8) {
                Dimension shift = new Dimension(-(width + this.offset), -halfHeight);
                target.setLocation(bounds.getLeft().getTranslated(shift));
            } else if (this.direction == 16) {
                Dimension shift = new Dimension(this.offset, -halfHeight);
                target.setLocation(bounds.getRight().getTranslated(shift));
            }
        }
    }
}

