/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.tools.PopupBarTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.bpmn.diagram.ui.PopupBarDescriptor;
import org.eclipse.stp.bpmn.diagram.ui.RoundedRectangleWithTail;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupBalloon {
    private int partHashCode;
    private static int ACTION_BUTTON_START_X = 5;
    private static int ACTION_BUTTON_START_Y = 5;
    private static int ACTION_MARGIN_RIGHT = 10;
    private static int ACTION_WIDTH_HGT = 30;
    private static double BALLOON_X_OFFSET_RHS = 0.65;
    private static double BALLOON_X_OFFSET_LHS = 0.25;
    private static int BALLOON_Y_OFFSET = 10;
    private static final int DISAPPEARANCE_DELAY = 1000;
    protected List<Image> imagesToBeDisposed = new LinkedList<Image>();
    private double myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    private IFigure myBalloon = null;
    private List<PopupBarDescriptor> myPopupBarDescriptors = new LinkedList<PopupBarDescriptor>();
    private IGraphicalEditPart parent;

    public PopupBalloon(IGraphicalEditPart part) {
        this.parent = part.getTopGraphicEditPart();
        this.partHashCode = part.hashCode();
    }

    public void addPopupBarDescriptor(String text, int severity) {
        PopupBarDescriptor p = new PopupBarDescriptor(text, severity);
        p.setShouldBeDisposed(false);
        this.myPopupBarDescriptors.add(p);
    }

    public void addPopupBarDescriptor(PopupBarDescriptor descriptor) {
        this.addPopupBarDescriptor(descriptor.getElementtype(), descriptor.getIcon(), (DragTracker)new PopupBarTool((EditPart)this.getParent(), descriptor.getElementtype()), descriptor.getToolTip());
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage) {
        this.addPopupBarDescriptor(elementType, theImage, (DragTracker)new PopupBarTool((EditPart)this.getParent(), elementType));
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, CreateRequest theRequest) {
        PopupBarTool theTracker = new PopupBarTool((EditPart)this.getParent(), theRequest);
        this.addPopupBarDescriptor(elementType, theImage, (DragTracker)theTracker);
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, DragTracker theTracker) {
        String theInputStr = DiagramUIMessages.PopupBar_AddNew;
        String theTip = NLS.bind((String)theInputStr, (Object)elementType.getDisplayName());
        this.addPopupBarDescriptor(elementType, theImage, theTracker, theTip);
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, DragTracker theTracker, String theTip) {
        PopupBarDescriptor desc = new PopupBarDescriptor(theTip, theImage, elementType, theTracker);
        this.myPopupBarDescriptors.add(desc);
    }

    public void addPopupBarDescriptor(IElementType elementType, Image theImage, String theTip) {
        PopupBarTool theTracker = new PopupBarTool((EditPart)this.getParent(), elementType);
        PopupBarDescriptor desc = new PopupBarDescriptor(theTip, theImage, elementType, (DragTracker)theTracker);
        this.myPopupBarDescriptors.add(desc);
    }

    protected IFigure createPopupBarFigure() {
        return new RoundedRectangleWithTail();
    }

    protected void fillPopupBarDescriptors() {
    }

    public IFigure getBalloon() {
        return this.myBalloon;
    }

    protected int getDisappearanceDelay() {
        return 1000;
    }

    protected IFigure getLayer(Object layer) {
        return LayerManager.Helper.find((EditPart)this.getParent()).getLayer(layer);
    }

    protected List<PopupBarDescriptor> getPopupBarDescriptors() {
        return this.myPopupBarDescriptors;
    }

    public void hide() {
        if (this.getBalloon() != null) {
            this.teardownPopupBar();
        }
    }

    protected void hideAfterDelay(int delay) {
        if (this.isShowing()) {
            Display.getCurrent().timerExec(delay, new Runnable(){

                public void run() {
                    PopupBalloon.this.hide();
                }
            });
        }
    }

    private void initPopupBars() {
        List<PopupBarDescriptor> theList = this.getPopupBarDescriptors();
        if (theList.isEmpty()) {
            return;
        }
        this.myBalloon = this.createPopupBarFigure();
        int xTotal = ACTION_MARGIN_RIGHT;
        int yTotal = 2 * ACTION_BUTTON_START_Y + ACTION_WIDTH_HGT;
        int xLoc = ACTION_BUTTON_START_X;
        int yLoc = ACTION_BUTTON_START_Y;
        for (PopupBarDescriptor theDesc : theList) {
            Label b = new Label(theDesc.getToolTip(), theDesc.getIcon());
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, yLoc);
            b.setFont(this.parent.getFigure().getFont());
            r1.setSize(b.getPreferredSize());
            b.setBounds(r1);
            xLoc += ACTION_WIDTH_HGT;
            this.getBalloon().add((IFigure)b);
            xTotal += r1.width;
            int n = yTotal = yTotal < r1.height ? r1.height : yTotal;
        }
        this.getBalloon().setSize(xTotal, yTotal);
    }

    public boolean isShowing() {
        return this.getBalloon() != null;
    }

    protected boolean isRightDisplay() {
        return BALLOON_X_OFFSET_RHS == this.myBallonOffsetPercent;
    }

    protected void setRightHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    }

    protected void populatePopupBars() {
        this.fillPopupBarDescriptors();
    }

    public void showBalloon(Point referencePoint, IGraphicalEditPart part) {
        this.partHashCode = part.hashCode();
        this.showBalloon(referencePoint);
    }

    public void showBalloon(Point referencePoint) {
        if (this.getBalloon() != null) {
            return;
        }
        this.populatePopupBars();
        this.initPopupBars();
        if (this.myPopupBarDescriptors.isEmpty()) {
            return;
        }
        IFigure layer = this.getLayer("Feedback Layer");
        layer.add(this.getBalloon());
        if (referencePoint == null) {
            throw new IllegalArgumentException("Reference point is null");
        }
        this.setLocation(referencePoint);
        this.hideAfterDelay(this.getDisappearanceDelay());
    }

    private void teardownPopupBar() {
        IFigure layer = this.getLayer("Feedback Layer");
        if (this.myBalloon.getParent() != null) {
            layer.remove(this.myBalloon);
        }
        this.myBalloon = null;
        for (PopupBarDescriptor desc : this.myPopupBarDescriptors) {
            if (!desc.shouldBeDisposed()) continue;
            this.imagesToBeDisposed.add(desc.getIcon());
        }
        this.myPopupBarDescriptors.clear();
        this.setRightHandDisplay();
        for (Image img : this.imagesToBeDisposed) {
            img.dispose();
        }
        this.imagesToBeDisposed.clear();
    }

    public IGraphicalEditPart getParent() {
        return this.parent;
    }

    public void setParent(IGraphicalEditPart _parent) {
        if (this.parent.getTopGraphicEditPart() != _parent) {
            this.parent = _parent.getTopGraphicEditPart();
        }
    }

    public void setLocation(Point location) {
        location.y -= this.getBalloon().getBounds().height;
        location.x -= 10;
        this.getBalloon().setLocation(location);
    }

    public boolean showsOnThisEditPart(IGraphicalEditPart part) {
        return part != null && part.hashCode() == this.partHashCode;
    }
}

