/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.connectionanchors.impl;

import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.BpmnAwareAnchorSupport;

public class ModelAwareAnchor
extends SlidableAnchor
implements IModelAwareAnchor {
    private String _connectionType;
    private int _orderNumber = -1;
    private int _count = -1;
    private Connection _connOwner;
    private int _srcOrTarget = 2;
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';

    public ModelAwareAnchor(IFigure fig, PrecisionPoint ref) {
        super(fig, ref);
    }

    public ModelAwareAnchor(IFigure fig) {
        super(fig);
    }

    public boolean isDefaultAnchor() {
        return this._connectionType == null;
    }

    public Point getLocation(Point reference) {
        return BpmnAwareAnchorSupport.INSTANCE.getLocation(this, reference);
    }

    public Point getReferencePoint() {
        return this.getLocation(null);
    }

    public int getOrderNumber() {
        return this._orderNumber;
    }

    public int getCount() {
        return this._count;
    }

    public String getConnectionType() {
        return this._connectionType;
    }

    public void setConnectionType(boolean isSource, String connectionType, int order, int count) {
        if (this._connectionType != null && !this._connectionType.equals(connectionType)) {
            System.err.println("Changing the connectyo " + this.hashCode() + " it was " + this._connectionType + " now " + connectionType);
        }
        if (this._connectionType == null || !this._connectionType.equals(connectionType) || order != this._orderNumber || this._count != count) {
            this._connectionType = connectionType;
            this._orderNumber = order;
            this._count = count;
            if (this.getOwner() instanceof IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable) {
                ((IModelAwareAnchor.INodeFigureAnchorTerminalUpdatable)this.getOwner()).updateTerminal(this);
            } else {
                System.err.println("warning the modelAnchor was not able to update its index in its owner " + this.getOwner() + " that does not implement " + "INodeFigureAnchorTerminalUpdatable.");
            }
            super.fireAnchorMoved();
        }
    }

    public Point getDefaultLocation(Point reference) {
        return super.getLocation(reference);
    }

    public int isSourceAnchor() {
        return this._srcOrTarget;
    }

    public int getPositionIndex() {
        return this._orderNumber;
    }

    public IFigure getOwner() {
        return super.getOwner();
    }

    public int getAnchorPositionningStyle() {
        return 1;
    }

    public Connection getConnectionOwner() {
        return this._connOwner;
    }

    public void addAnchorListener(AnchorListener listener) {
        boolean doFireMove = false;
        if (listener instanceof Connection) {
            Connection conn = (Connection)listener;
            if (conn.getSourceAnchor() == this && (this._connOwner != listener || this._srcOrTarget != 0)) {
                this._srcOrTarget = 0;
                this._connOwner = conn;
                doFireMove = true;
            } else if (conn.getTargetAnchor() == this && (this._connOwner != listener || this._srcOrTarget != 1)) {
                this._srcOrTarget = 1;
                this._connOwner = conn;
                doFireMove = true;
            }
        }
        super.addAnchorListener(listener);
        if (doFireMove) {
            super.fireAnchorMoved();
        }
    }

    public void removeAnchorListener(AnchorListener listener) {
        boolean doFireMove = false;
        if (this._connOwner == listener) {
            this._srcOrTarget = 2;
            this._connOwner = null;
            doFireMove = true;
        }
        super.removeAnchorListener(listener);
        if (doFireMove) {
            super.fireAnchorMoved();
        }
    }

    public String getTerminal() {
        if (this.isDefaultAnchor()) {
            if (this._connectionType != null) {
                return this._connectionType;
            }
            return "";
        }
        return String.valueOf(this.composeTerminalString(new PrecisionPoint(this.getReferencePoint()))) + this._connectionType;
    }

    private String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append((float)p.preciseX);
        s.append(',');
        s.append((float)p.preciseY);
        s.append(')');
        return s.toString();
    }
}

