/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpmnDiagramXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        if (request.getMoveDelta() != null) {
            request.setMoveDelta(new Point(0, request.getMoveDelta().y));
        }
        CompoundCommand resize = new CompoundCommand();
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        int maxWidth = this.fillMapAndSetCalcMaxWidth(map, set, request, resize);
        this.doLayout(map, set, maxWidth, resize, request);
        return resize.unwrap();
    }

    private void doLayout(Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> set, int maxWidth, CompoundCommand cc, ChangeBoundsRequest requestOrNull) {
        Iterator iterat = set.iterator();
        Rectangle firstBounds = (Rectangle)iterat.next();
        int yDelta = 0 - firstBounds.y;
        firstBounds.setLocation(firstBounds.x, 0);
        firstBounds.width = maxWidth;
        while (iterat.hasNext()) {
            Rectangle element = (Rectangle)iterat.next();
            element.setLocation(element.x, element.y + yDelta);
            element.width = maxWidth;
        }
        ArrayList<Rectangle> list = new ArrayList<Rectangle>(set);
        firstBounds = (Rectangle)list.get(0);
        int i = 1;
        while (i < list.size()) {
            Rectangle secondBounds = (Rectangle)list.get(i);
            if (firstBounds.y + firstBounds.height + 5 > secondBounds.y) {
                yDelta = firstBounds.y + firstBounds.height + 5 - secondBounds.y;
                secondBounds.setLocation(firstBounds.x, firstBounds.y + firstBounds.height + 5);
                int j = i + 1;
                while (j < list.size()) {
                    Rectangle element = (Rectangle)list.get(j);
                    element.setLocation(element.x, element.y + yDelta);
                    ++j;
                }
            }
            firstBounds = secondBounds;
            ++i;
        }
        Set<Map.Entry<IGraphicalEditPart, Rectangle>> entries = map.entrySet();
        for (Map.Entry<IGraphicalEditPart, Rectangle> outerEntry : entries) {
            EditPolicy compartmentRefresh;
            PoolPoolCompartmentEditPart poolCompartment;
            IGraphicalEditPart pep = outerEntry.getKey();
            Rectangle rect = outerEntry.getValue();
            Rectangle prevBounds = pep.getFigure().getBounds();
            if (prevBounds.equals((Object)rect)) continue;
            Command c = this.createChangeConstraintCommand((EditPart)pep, rect);
            cc.add(c);
            if (requestOrNull == null || !(pep instanceof PoolEditPart) || (poolCompartment = (PoolPoolCompartmentEditPart)((PoolEditPart)pep).getChildBySemanticHint(BpmnVisualIDRegistry.getType(5001))) == null || (c = (compartmentRefresh = poolCompartment.getEditPolicy("LayoutEditPolicy")).getCommand((Request)requestOrNull)) == null || c == UnexecutableCommand.INSTANCE) continue;
            cc.add(c);
        }
    }

    private int fillMapAndSetCalcMaxWidth(Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> set, ChangeBoundsRequest request, CompoundCommand cc) {
        List children = request != null ? request.getEditParts() : Collections.EMPTY_LIST;
        List allChildren = this.getHost().getChildren();
        Iterator iter = allChildren.iterator();
        int maxWidth = -1;
        while (iter.hasNext()) {
            IGraphicalEditPart child = (IGraphicalEditPart)iter.next();
            int x = 10;
            if (child instanceof PoolEditPart) {
                Rectangle bounds;
                if (children.contains(child)) {
                    bounds = (Rectangle)this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child));
                    bounds.x = x;
                } else {
                    int y = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    int width = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                    int height = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                    bounds = new Rectangle(x, y, width, height);
                }
                if (bounds.width > maxWidth) {
                    maxWidth = bounds.width;
                }
                map.put(child, bounds);
                set.add(bounds);
                continue;
            }
            if (!children.contains(child)) continue;
            Command c = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child)));
            cc.add(c);
        }
        return maxWidth;
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        int maxWidth = this.fillMapAndSetCalcMaxWidth(map, set, null, null);
        HashMap<CreateViewRequest.ViewDescriptor, Rectangle> descriptorsMap = new HashMap<CreateViewRequest.ViewDescriptor, Rectangle>();
        while (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            rect.x = 16;
            if (rect.height < 200) {
                rect.height = 200;
            }
            if (rect.width > maxWidth) {
                maxWidth = rect.width;
            }
            descriptorsMap.put(viewDescriptor, rect);
            set.add(rect);
        }
        if (map.size() == 0 && maxWidth == -1) {
            maxWidth = this.getHostFigure().getBounds().width - 25;
        } else if (maxWidth < 100) {
            maxWidth = 100;
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        this.doLayout(map, set, maxWidth, compoundCommand, null);
        if (compoundCommand.canExecute()) {
            cc.compose((IUndoableOperation)new CommandProxy((Command)compoundCommand));
        }
        for (Map.Entry entry : descriptorsMap.entrySet()) {
            cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)entry.getKey(), (Rectangle)entry.getValue()));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RectanglesComparator
    implements Comparator<Rectangle> {
        RectanglesComparator() {
        }

        @Override
        public int compare(Rectangle r1, Rectangle r2) {
            if (r1.y > r2.y) {
                return 1;
            }
            if (r1.y < r2.y) {
                return -1;
            }
            return 0;
        }
    }
}

