/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolPoolCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    public static final Insets INSETS = new Insets(5, 6, 5, 5);

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        CompoundCommand resize = new CompoundCommand();
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        this.fillMapAndSet(map, set, request, resize);
        if (map.isEmpty()) {
            return super.getResizeChildrenCommand(request);
        }
        this.doLayout(request, map, set, resize, null);
        return resize.unwrap();
    }

    private void fillMapAndSet(Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> orderedLaneBounds, ChangeBoundsRequest request, CompoundCommand cc) {
        List children = request != null ? request.getEditParts() : Collections.EMPTY_LIST;
        List allChildren = this.getHost().getChildren();
        for (IGraphicalEditPart child : allChildren) {
            int x = 0;
            if (child instanceof LaneEditPart) {
                Rectangle bounds;
                if (children.contains(child)) {
                    bounds = (Rectangle)this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child));
                    bounds.x = x;
                } else {
                    int y = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                    int width = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                    int height = (Integer)child.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                    bounds = new Rectangle(x, y, width, height);
                }
                map.put(child, bounds);
                orderedLaneBounds.add(bounds);
                continue;
            }
            if (!children.contains(child)) continue;
            Command c = this.createChangeConstraintCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, (GraphicalEditPart)child)));
            cc.add(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doLayout(ChangeBoundsRequest request, Map<IGraphicalEditPart, Rectangle> map, SortedSet<Rectangle> set, CompoundCommand cc, Set<Rectangle> insertedRectangles) {
        if (request != null && request.getEditParts() != null && request.getEditParts().size() == 1 && request.getEditParts().get(0) instanceof PoolEditPart) {
            PoolEditPart container = (PoolEditPart)((Object)request.getEditParts().get(0));
            if (container != this.getHost().getParent() || request.getSizeDelta().height == 0) return;
            Rectangle r = null;
            if (request.getMoveDelta().y != 0) {
                Iterator it = set.iterator();
                r = (Rectangle)it.next();
                r.setSize(r.width, r.height + request.getSizeDelta().height);
                if (it.hasNext()) {
                    Rectangle second = (Rectangle)it.next();
                    second.y = r.y + r.height;
                }
            } else {
                r = set.last();
                r.setSize(r.width, r.height + request.getSizeDelta().height);
            }
        } else if (request != null) {
            if (request.getMoveDelta().y != 0 && request.getSizeDelta().height == -request.getMoveDelta().y) {
                LinkedList<Rectangle> rects = new LinkedList<Rectangle>(set);
                Rectangle prevLast = null;
                while (!rects.isEmpty()) {
                    Rectangle last = rects.removeLast();
                    if (prevLast != null && prevLast.y != last.y + last.height) {
                        int cfr_ignored_0 = last.y;
                        int cfr_ignored_1 = last.y + last.height;
                        last.height = prevLast.y - last.y;
                        if (last.height <= 48) {
                            last.height = 48;
                            int prevBottomY = prevLast.y + prevLast.height;
                            prevLast.y = last.y + last.height;
                            prevLast.height = prevBottomY - prevLast.y;
                        }
                    }
                    prevLast = last;
                }
            } else {
                Rectangle firstBounds = null;
                for (Rectangle secondBounds : set) {
                    if (firstBounds != null && firstBounds.y + firstBounds.height != secondBounds.y || secondBounds.y != PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top) {
                        int heightDelta = -secondBounds.y;
                        if (firstBounds == null) {
                            secondBounds.setLocation(0, PoolPoolCompartmentXYLayoutEditPolicy.INSETS.top);
                        } else {
                            secondBounds.setLocation(0, firstBounds.y + firstBounds.height);
                        }
                        secondBounds.setSize(secondBounds.width, secondBounds.height - (heightDelta += secondBounds.y));
                    }
                    firstBounds = secondBounds;
                }
                Point bottomLane = firstBounds.getBottom();
                Point bottomPool = this.getHostFigure().getBounds().getBottom();
                if (bottomLane.y != bottomPool.y - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.bottom) {
                    firstBounds.setSize(firstBounds.width, firstBounds.height + bottomPool.y - bottomLane.y - PoolPoolCompartmentXYLayoutEditPolicy.INSETS.bottom);
                }
            }
        }
        Set<Map.Entry<IGraphicalEditPart, Rectangle>> entries = map.entrySet();
        for (Map.Entry<IGraphicalEditPart, Rectangle> outerEntry : entries) {
            IGraphicalEditPart pep = outerEntry.getKey();
            Rectangle rect = outerEntry.getValue();
            Rectangle prevBounds = pep.getFigure().getBounds();
            if (prevBounds.equals((Object)rect)) continue;
            Command c = this.createChangeConstraintCommand((EditPart)pep, rect);
            cc.add(c);
        }
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        HashMap<IGraphicalEditPart, Rectangle> map = new HashMap<IGraphicalEditPart, Rectangle>();
        TreeSet<Rectangle> set = new TreeSet<Rectangle>(new RectanglesComparator());
        this.fillMapAndSet(map, set, null, null);
        HashMap<CreateViewRequest.ViewDescriptor, Rectangle> descriptorsMap = new HashMap<CreateViewRequest.ViewDescriptor, Rectangle>();
        HashSet<Rectangle> insertedRectangles = null;
        while (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            if (viewDescriptor.getSemanticHint().equals(String.valueOf(2004))) {
                rect.x = 0;
                Point location = req.getLocation().getCopy();
                this.getHostFigure().translateToRelative((Translatable)location);
                int ind = 0;
                for (Rectangle otherLane : set) {
                    if (otherLane.y < location.y && otherLane.y + otherLane.height >= location.y) {
                        otherLane.height /= 2;
                        rect.height = otherLane.height;
                        if (otherLane.y + otherLane.height >= location.y) {
                            rect.y = otherLane.y;
                            otherLane.y += rect.height + 2;
                            break;
                        }
                        rect.y = otherLane.y + rect.height + 2;
                        break;
                    }
                    ++ind;
                }
                if (insertedRectangles == null) {
                    insertedRectangles = new HashSet<Rectangle>();
                }
                if (ind == set.size()) {
                    rect.y = PoolPoolCompartmentEditPart.INSETS.top;
                    rect.height = this.getHostFigure().getBounds().height - PoolPoolCompartmentEditPart.INSETS.top - PoolPoolCompartmentEditPart.INSETS.bottom;
                }
                insertedRectangles.add(rect);
            }
            descriptorsMap.put(viewDescriptor, rect);
        }
        if (insertedRectangles != null) {
            set.addAll(insertedRectangles);
        }
        CompoundCommand compoundCommand = new CompoundCommand();
        this.doLayout(null, map, set, compoundCommand, insertedRectangles);
        if (compoundCommand.canExecute()) {
            cc.compose((IUndoableOperation)new CommandProxy((Command)compoundCommand));
        }
        for (Map.Entry entry : descriptorsMap.entrySet()) {
            cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)entry.getKey(), (Rectangle)entry.getValue()));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, (Command)new ICommandProxy(cc.reduce()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RectanglesComparator
    implements Comparator<Rectangle> {
        RectanglesComparator() {
        }

        @Override
        public int compare(Rectangle r1, Rectangle r2) {
            if (r1.y > r2.y) {
                return 1;
            }
            if (r1.y < r2.y) {
                return -1;
            }
            return 0;
        }
    }
}

