/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.swt.SWT;

public class PoolResizeTracker
extends ResizeTracker {
    private GraphicalEditPart owner;
    private PrecisionRectangle sourceRect;
    private SnapToHelper snapToHelper;

    public PoolResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        this.owner = owner;
    }

    public void activate() {
        if (this.owner != null) {
            IFigure figure;
            if (this.getTargetEditPart() != null) {
                this.snapToHelper = (SnapToHelper)this.getTargetEditPart().getAdapter(SnapToHelper.class);
            }
            this.sourceRect = (figure = this.owner.getFigure()) instanceof HandleBounds ? new PrecisionRectangle(((HandleBounds)figure).getHandleBounds()) : new PrecisionRectangle(figure.getBounds());
        }
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        this.sourceRect = null;
        this.snapToHelper = null;
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        List part = this.getOperationSet();
        List siblings = null;
        request.setConstrainedResize(false);
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        if (this.hasPoolEditPart(part) && (direction == 16 || direction == 8 || direction == 17 || direction == 9 || direction == 20 || direction == 20)) {
            int k = 0;
            while (k < part.size()) {
                if (part.get(k) instanceof PoolEditPart) {
                    siblings = ((PoolEditPart)((Object)part.get(k))).getParent().getChildren();
                }
                ++k;
            }
            int i = 0;
            while (i < siblings.size()) {
                if (!part.contains(siblings.get(i))) {
                    part.add(siblings.get(i));
                }
                ++i;
            }
        }
        if ((direction & 1) != 0 && part.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (this.getMinPoolSize((List)part).height > this.owner.getFigure().getBounds().height - 2 * d.height) {
                    d.setSize(new Dimension(d.width, (this.owner.getFigure().getBounds().height - this.getMinPoolSize((List)part).height) / 2));
                }
                resizeDelta.height -= d.height;
            } else if (this.getMinPoolSize((List)part).height > this.owner.getFigure().getBounds().height - d.height) {
                d.setSize(new Dimension(d.width, this.owner.getFigure().getBounds().height - this.getMinPoolSize((List)part).height));
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((direction & 4) != 0 && part.size() < 2) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (this.getMinPoolSize((List)part).height > this.owner.getFigure().getBounds().height + 2 * d.height) {
                    d.setSize(new Dimension(d.width, -(this.owner.getFigure().getBounds().height - this.getMinPoolSize((List)part).height) / 2));
                }
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            } else if (this.getMinPoolSize((List)part).height > this.owner.getFigure().getBounds().height + d.height) {
                d.setSize(new Dimension(d.width, -(this.owner.getFigure().getBounds().height - this.getMinPoolSize((List)part).height)));
            }
            resizeDelta.height += d.height;
        }
        if ((direction & 8) != 0) {
            if (this.getMinPoolSize((List)part).width > this.owner.getFigure().getBounds().width - d.width) {
                d.setSize(new Dimension(this.owner.getFigure().getBounds().width - this.getMinPoolSize((List)siblings).width, d.height));
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((direction & 0x10) != 0) {
            if (this.getMinPoolSize((List)part).width > this.owner.getFigure().getBounds().width + d.width) {
                d.setSize(new Dimension(-(this.owner.getFigure().getBounds().width - this.getMinPoolSize((List)siblings).width), d.height));
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(part);
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && this.snapToHelper != null) {
            PrecisionRectangle rect = this.sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            this.snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    private boolean hasPoolEditPart(List parts) {
        int i = 0;
        while (i < parts.size()) {
            if (parts.get(i) instanceof PoolEditPart) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Dimension getMinPoolSize(List parts) {
        Dimension result = new Dimension(150, 50);
        int i = 0;
        while (i < parts.size()) {
            if (parts.get(i) instanceof PoolEditPart) {
                Rectangle rect = ((PoolEditPart)((Object)parts.get(i))).getPoolContainRectangle();
                if (rect.height + 10 > result.height) {
                    result.setSize(new Dimension(result.width, rect.height + 10));
                }
                if (rect.width + 30 > result.width) {
                    result.setSize(new Dimension(rect.width + 30, result.height));
                }
            }
            ++i;
        }
        return result;
    }
}

