/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.lang.reflect.Field;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.swt.SWT;

public class ActivityResizeTracker
extends ResizeTracker {
    private static Field ownerField;
    private static Field sourceRectField;
    private static Field snapToHelperField;

    private static void init() {
        if (ownerField != null) {
            return;
        }
        try {
            ownerField = ResizeTracker.class.getDeclaredField("owner");
            ownerField.setAccessible(true);
            sourceRectField = ResizeTracker.class.getDeclaredField("sourceRect");
            sourceRectField.setAccessible(true);
            snapToHelperField = ResizeTracker.class.getDeclaredField("snapToHelper");
            snapToHelperField.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    public ActivityResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
        ActivityResizeTracker.init();
    }

    protected GraphicalEditPart getOwner() {
        try {
            return (GraphicalEditPart)ownerField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected SnapToHelper getSnapToHelper() {
        try {
            return (SnapToHelper)snapToHelperField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected PrecisionRectangle getSourceRectangle() {
        try {
            return (PrecisionRectangle)sourceRectField.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void updateSourceRequest() {
        EObject semanticElement;
        GraphicalEditPart owner = this.getOwner();
        if (owner != null && owner.getModel() instanceof View && (!((semanticElement = ((View)owner.getModel()).getElement()) instanceof Activity) || ((Activity)semanticElement).getActivityType().getValue() == 0)) {
            super.updateSourceRequest();
            return;
        }
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        int direction = this.getResizeDirection();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        if (owner != null) {
            request.setConstrainedResize(true);
            if (direction == 20) {
                if ((float)d.height > (float)d.width * 1.0f) {
                    d.width = (int)((float)d.height / 1.0f);
                } else {
                    d.height = (int)((float)d.width * 1.0f);
                }
            } else if (direction == 9) {
                if ((float)d.height < (float)d.width * 1.0f) {
                    d.width = (int)((float)d.height / 1.0f);
                } else {
                    d.height = (int)((float)d.width * 1.0f);
                }
            } else if (direction == 17) {
                if ((float)(-d.height) > (float)d.width * 1.0f) {
                    d.width = -((int)((float)d.height / 1.0f));
                } else {
                    d.height = -((int)((float)d.width * 1.0f));
                }
            } else if (direction == 12) {
                if ((float)(-d.height) < (float)d.width * 1.0f) {
                    d.width = -((int)((float)d.height / 1.0f));
                } else {
                    d.height = -((int)((float)d.width * 1.0f));
                }
            } else if (direction == 1) {
                direction |= 0x10;
                d.width = -((int)((float)d.height / 1.0f));
            } else if (direction == 4) {
                direction |= 0x10;
                d.width = (int)((float)d.height / 1.0f);
            } else if (direction == 16) {
                direction |= 4;
                d.height = (int)((float)d.width * 1.0f);
            } else if (direction == 8) {
                direction |= 4;
                d.height = -((int)((float)d.width * 1.0f));
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        if ((direction & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.height -= d.height;
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((direction & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            }
            resizeDelta.height += d.height;
        }
        if ((direction & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                resizeDelta.width -= d.width;
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((direction & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            if (preciseResize.width != preciseResize.height) {
                preciseResize.preciseHeight = preciseResize.preciseWidth;
                preciseResize.updateInts();
            }
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }
}

