/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.tools.ConnectionValidator;

public class EdgeConnectionValidator
implements ConnectionValidator {
    public boolean canStart(EditPart sourceEditPart) {
        if (sourceEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)sourceEditPart.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            switch (activityType) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return false;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    if (((ActivityEditPart)sourceEditPart).getSourceConnections().size() <= 0 || ((ActivityEditPart)sourceEditPart).getTargetConnections().size() <= 1) break;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canEnd(EditPart targetEditPart) {
        if (targetEditPart instanceof ActivityEditPart) {
            EObject element = ((Node)targetEditPart.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            switch (activityType) {
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    if (((ActivityEditPart)targetEditPart).getSourceConnections().size() <= 1 || ((ActivityEditPart)targetEditPart).getTargetConnections().size() <= 0) break;
                    return false;
                }
            }
        } else if (targetEditPart instanceof Activity2EditPart) {
            return false;
        }
        return true;
    }

    public boolean canConnect(EditPart source, EditPart target) {
        if (source.equals(target)) {
            return false;
        }
        if (!this.canEnd(target)) {
            return false;
        }
        if (!this.canStart(source)) {
            return false;
        }
        if (source instanceof Activity2EditPart) {
            if (!this.getGraph(source).equals(this.getGraph(target)) && !this.getGraph(this.getGraph(source)).equals(this.getGraph(target))) {
                return false;
            }
            if (this.getGraph(source).equals(target)) {
                return false;
            }
        } else if (!this.getGraph(source).equals(this.getGraph(target))) {
            return false;
        }
        return true;
    }

    protected EditPart getGraph(EditPart ep) {
        if (ep instanceof PoolEditPart) {
            return ep;
        }
        EditPart parent = ep.getParent();
        while (!(parent instanceof PoolEditPart)) {
            if (parent instanceof SubProcessEditPart) break;
            parent = parent.getParent();
        }
        return parent;
    }
}

