/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Ray;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouterUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.RectilinearRouter;

public class MessageRectilinearRouter
extends RectilinearRouter {
    protected void updateIfNotRectilinear(Connection conn, PointList newLine) {
        boolean isRectilinear = true;
        Rectangle startRect = new Rectangle(conn.getSourceAnchor().getOwner().getBounds());
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        conn.translateToRelative((Translatable)startRect);
        Dimension buffer = new Dimension(2, 2);
        conn.translateToRelative((Translatable)buffer);
        startRect.expand(buffer.width, buffer.height);
        Rectangle endRect = new Rectangle(conn.getTargetAnchor().getOwner().getBounds());
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        conn.translateToRelative((Translatable)endRect);
        endRect.expand(buffer.width, buffer.height);
        if (!startRect.contains(newLine.getPoint(0))) {
            newLine.getFirstPoint().setLocation(newLine.getFirstPoint().x, startRect.y + startRect.height);
        }
        int i = 0;
        while (i < newLine.size() - 1) {
            Ray segVector = new Ray(newLine.getPoint(i), newLine.getPoint(i + 1));
            if (segVector.x != 0 && segVector.y != 0) {
                isRectilinear = false;
                break;
            }
            ++i;
        }
        if (!isRectilinear) {
            Point p2;
            Point p1;
            Point p0;
            OrthogonalRouterUtilities.resetEndPointsToCenter((Connection)conn, (PointList)newLine);
            PointList oldPoints = PointListUtilities.copyPoints((PointList)newLine);
            PointList newPoints = new PointList();
            newPoints.addPoint(oldPoints.removePoint(0));
            while (oldPoints.size() > 0) {
                if (oldPoints.size() >= 2) {
                    p0 = newPoints.getLastPoint();
                    p1 = oldPoints.removePoint(0);
                    p2 = oldPoints.removePoint(0);
                    if (Math.abs(p2.y - p0.y) > Math.abs(p2.x - p0.x)) {
                        newPoints.addPoint(new Point(p1.x, p0.y));
                        newPoints.addPoint(new Point(p1.x, p2.y));
                    } else {
                        newPoints.addPoint(new Point(p0.x, p1.y));
                        newPoints.addPoint(new Point(p2.x, p1.y));
                    }
                    newPoints.addPoint(p2);
                    continue;
                }
                if (oldPoints.size() != 1) continue;
                p0 = newPoints.getLastPoint();
                p1 = oldPoints.removePoint(0);
                if (Math.abs(p1.y - p0.y) > Math.abs(p1.x - p0.x)) {
                    newPoints.addPoint(new Point(p1.x, p0.y));
                } else {
                    newPoints.addPoint(new Point(p0.x, p1.y));
                }
                newPoints.addPoint(p1);
            }
            oldPoints.removeAllPoints();
            oldPoints.addPoint(newPoints.removePoint(0));
            while (newPoints.size() >= 2) {
                p0 = oldPoints.getLastPoint();
                p1 = newPoints.getPoint(0);
                p2 = newPoints.getPoint(1);
                if (p0.x == p1.x && p0.x == p2.x) {
                    newPoints.removePoint(0);
                    continue;
                }
                if (p0.y == p1.y && p0.y == p2.y) {
                    newPoints.removePoint(0);
                    continue;
                }
                oldPoints.addPoint(newPoints.removePoint(0));
            }
            while (newPoints.size() > 0) {
                oldPoints.addPoint(newPoints.removePoint(0));
            }
            newLine.removeAllPoints();
            int i2 = 0;
            while (i2 < oldPoints.size()) {
                newLine.addPoint(oldPoints.getPoint(i2));
                ++i2;
            }
        }
    }

    protected void straightenPoints(PointList newLine) {
        if (newLine.size() == 2) {
            Point ptCurrent = newLine.getPoint(0);
            Point ptNext = newLine.getPoint(1);
            if (ptNext.x != ptCurrent.x) {
                newLine.removeAllPoints();
                newLine.addPoint(ptCurrent);
                newLine.addPoint(ptNext.x, ptCurrent.y);
                newLine.addPoint(ptNext);
            }
        }
    }

    protected boolean checkEndSegments(Connection conn, PointList newLine) {
        boolean bOk = true;
        Dimension connection_offset = new Dimension(26, 0);
        conn.translateToRelative((Translatable)connection_offset);
        if (newLine.size() > 2) {
            Point ptNext;
            Point ptFix = new Point(newLine.getPoint(1));
            if (!this.checkEndSegment(conn, conn.getSourceAnchor(), ptFix, connection_offset.width / 2)) {
                newLine.setPoint(ptFix, 1);
                ptNext = newLine.getPoint(2);
                this.makeOrthogonal(ptFix, ptNext);
                newLine.setPoint(ptNext, 2);
                bOk = false;
            }
            ptFix = new Point(newLine.getPoint(newLine.size() - 2));
            if (!this.checkEndSegment(conn, conn.getTargetAnchor(), ptFix, connection_offset.width / 2)) {
                newLine.setPoint(ptFix, newLine.size() - 2);
                ptNext = newLine.getPoint(newLine.size() - 3);
                this.makeOrthogonal(ptFix, ptNext);
                newLine.setPoint(ptNext, newLine.size() - 3);
                bOk = false;
            }
        }
        return bOk;
    }

    private void makeOrthogonal(Point ptCurrent, Point ptNext) {
        if (Math.abs(ptNext.x - ptCurrent.x) < Math.abs(ptNext.y - ptCurrent.y)) {
            ptNext.x = ptCurrent.x;
        } else {
            ptNext.y = ptCurrent.y;
        }
    }

    public void routeLine(Connection conn, int nestedRoutingDepth, PointList newLine) {
        super.routeLine(conn, nestedRoutingDepth, newLine);
        if (newLine.size() >= 3) {
            Rectangle startRect = new Rectangle(conn.getSourceAnchor().getOwner().getBounds());
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
            conn.translateToRelative((Translatable)startRect);
            Rectangle endRect = new Rectangle(conn.getTargetAnchor().getOwner().getBounds());
            conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
            conn.translateToRelative((Translatable)endRect);
            Point spt = newLine.getFirstPoint();
            Point mpt = newLine.getMidpoint();
            Point ept = newLine.getLastPoint();
            if (spt.y < ept.y) {
                if (spt.y < startRect.y + startRect.height / 2) {
                    spt.setLocation(spt.x, startRect.y + startRect.height);
                    if (spt.x == mpt.x) {
                        newLine.removePoint(0);
                        newLine.insertPoint(spt, 0);
                    } else {
                        mpt.setLocation(mpt.x, startRect.y + startRect.height);
                        newLine.removePoint(0);
                        newLine.insertPoint(spt, 0);
                        newLine.removePoint(1);
                        newLine.insertPoint(mpt, 1);
                    }
                }
                if (ept.y > endRect.y + endRect.height / 2) {
                    ept.setLocation(ept.x, endRect.y);
                    if (ept.x == mpt.x) {
                        newLine.removePoint(2);
                        newLine.insertPoint(ept, 2);
                    } else {
                        mpt.setLocation(mpt.x, endRect.y);
                        newLine.removePoint(2);
                        newLine.insertPoint(ept, 2);
                        newLine.removePoint(1);
                        newLine.insertPoint(mpt, 1);
                    }
                }
            } else if (spt.y > ept.y) {
                if (spt.y > startRect.y + startRect.height / 2) {
                    spt.setLocation(spt.x, startRect.y);
                    if (spt.x == mpt.x) {
                        newLine.removePoint(0);
                        newLine.insertPoint(spt, 0);
                    } else {
                        mpt.setLocation(mpt.x, startRect.y);
                        newLine.removePoint(0);
                        newLine.insertPoint(spt, 0);
                        newLine.removePoint(1);
                        newLine.insertPoint(mpt, 1);
                    }
                }
                if (ept.y < endRect.y + endRect.height / 2) {
                    ept.setLocation(ept.x, endRect.y + endRect.height);
                    if (ept.x == mpt.x) {
                        newLine.removePoint(2);
                        newLine.insertPoint(ept, 2);
                    } else {
                        mpt.setLocation(mpt.x, endRect.y + endRect.height);
                        newLine.removePoint(2);
                        newLine.insertPoint(ept, 2);
                        newLine.removePoint(1);
                        newLine.insertPoint(mpt, 1);
                    }
                }
            }
        }
    }
}

