/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.swt.SWT;

public class SubProcessResizeTracker
extends ActivityResizeTracker {
    public SubProcessResizeTracker(GraphicalEditPart owner, int direction) {
        super(owner, direction);
    }

    protected void updateSourceRequest() {
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getSourceRequest();
        Dimension d = this.getDragMoveDelta();
        Point location = new Point(this.getLocation());
        Point moveDelta = new Point(0, 0);
        Dimension resizeDelta = new Dimension(0, 0);
        GraphicalEditPart owner = this.getOwner();
        PrecisionRectangle sourceRect = this.getSourceRectangle();
        SnapToHelper snapToHelper = this.getSnapToHelper();
        if (this.getCurrentInput().isShiftKeyDown() && owner != null) {
            request.setConstrainedResize(true);
            int origHeight = owner.getFigure().getBounds().height;
            int origWidth = owner.getFigure().getBounds().width;
            float ratio = 1.0f;
            if (origWidth != 0 && origHeight != 0) {
                ratio = (float)origHeight / (float)origWidth;
            }
            if (this.getResizeDirection() == 20) {
                if ((float)d.height > (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 9) {
                if ((float)d.height < (float)d.width * ratio) {
                    d.width = (int)((float)d.height / ratio);
                } else {
                    d.height = (int)((float)d.width * ratio);
                }
            } else if (this.getResizeDirection() == 17) {
                if ((float)(-d.height) > (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            } else if (this.getResizeDirection() == 12) {
                if ((float)(-d.height) < (float)d.width * ratio) {
                    d.width = -((int)((float)d.height / ratio));
                } else {
                    d.height = -((int)((float)d.width * ratio));
                }
            }
        } else {
            request.setConstrainedResize(false);
        }
        request.setCenteredResize(this.getCurrentInput().isModKeyDown(SWT.MOD1));
        Dimension minSize = this.getSubProcessMinSize(owner);
        Dimension figureSize = owner.getFigure().getSize();
        RootEditPart rootEditPart = owner.getRoot();
        if (rootEditPart instanceof ScalableFreeformRootEditPart) {
            double zoom = ((ScalableFreeformRootEditPart)rootEditPart).getZoomManager().getZoom();
            minSize.scale(zoom);
            figureSize.scale(zoom);
        }
        if ((this.getResizeDirection() & 1) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height - 2 * d.height) {
                    d.setSize(new Dimension(d.width, (figureSize.height - minSize.height) / 2));
                }
                resizeDelta.height -= d.height;
            } else if (minSize.height > figureSize.height - d.height) {
                d.setSize(new Dimension(d.width, figureSize.height - minSize.height));
            }
            moveDelta.y += d.height;
            resizeDelta.height -= d.height;
        }
        if ((this.getResizeDirection() & 4) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.height > figureSize.height + 2 * d.height) {
                    d.setSize(new Dimension(d.width, -(figureSize.height - minSize.height) / 2));
                }
                moveDelta.y -= d.height;
                resizeDelta.height += d.height;
            } else if (minSize.height > figureSize.height + d.height) {
                d.setSize(new Dimension(d.width, -(figureSize.height - minSize.height)));
            }
            resizeDelta.height += d.height;
        }
        if ((this.getResizeDirection() & 8) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.width > figureSize.width - 2 * d.width) {
                    d.setSize(new Dimension((figureSize.width - minSize.width) / 2, d.height));
                }
                resizeDelta.width -= d.width;
            } else if (minSize.width > figureSize.width - d.width) {
                d.setSize(new Dimension(figureSize.width - minSize.width, d.height));
            }
            moveDelta.x += d.width;
            resizeDelta.width -= d.width;
        }
        if ((this.getResizeDirection() & 0x10) != 0) {
            if (this.getCurrentInput().isControlKeyDown()) {
                if (minSize.width > figureSize.width + 2 * d.width) {
                    d.setSize(new Dimension(-(figureSize.width - minSize.width) / 2, d.height));
                }
                moveDelta.x -= d.width;
                resizeDelta.width += d.width;
            } else if (minSize.width > figureSize.width + d.width) {
                d.setSize(new Dimension(-(figureSize.width - minSize.width), d.height));
            }
            resizeDelta.width += d.width;
        }
        request.setMoveDelta(moveDelta);
        request.setSizeDelta(resizeDelta);
        request.setLocation(location);
        request.setEditParts(this.getOperationSet());
        request.getExtendedData().clear();
        if (!this.getCurrentInput().isAltKeyDown() && snapToHelper != null) {
            PrecisionRectangle rect = sourceRect.getPreciseCopy();
            rect.translate(moveDelta);
            rect.resize(resizeDelta);
            PrecisionRectangle result = new PrecisionRectangle();
            snapToHelper.snapRectangle((Request)request, request.getResizeDirection(), rect, result);
            if (request.isCenteredResize()) {
                if (result.preciseX != 0.0) {
                    result.preciseWidth += -result.preciseX;
                } else if (result.preciseWidth != 0.0) {
                    result.preciseX = -result.preciseWidth;
                    result.preciseWidth *= 2.0;
                }
                if (result.preciseY != 0.0) {
                    result.preciseHeight += -result.preciseY;
                } else if (result.preciseHeight != 0.0) {
                    result.preciseY = -result.preciseHeight;
                    result.preciseHeight *= 2.0;
                }
                result.updateInts();
            }
            PrecisionPoint preciseMove = new PrecisionPoint(result.x + moveDelta.x, result.y + moveDelta.y);
            PrecisionDimension preciseResize = new PrecisionDimension((double)(result.width + resizeDelta.width), (double)(result.height + resizeDelta.height));
            if (minSize.width > figureSize.width + preciseResize.width) {
                preciseResize.preciseWidth = resizeDelta.width;
                preciseResize.updateInts();
            }
            if (minSize.height > figureSize.height + preciseResize.height) {
                preciseResize.preciseHeight = resizeDelta.height;
                preciseResize.updateInts();
            }
            request.setMoveDelta((Point)preciseMove);
            request.setSizeDelta((Dimension)preciseResize);
        }
    }

    public Dimension getSubProcessMinSize(GraphicalEditPart subprocessEditPart) {
        return ((SubProcessEditPart)subprocessEditPart).calcMinSize();
    }

    protected Dimension getDragMoveDelta() {
        Dimension d = super.getDragMoveDelta();
        return d;
    }

    protected void performDrag() {
        GraphicalEditPart owner = this.getOwner();
        ((SubProcessEditPart)owner).setNeedToUpdateContainer(true);
        super.performDrag();
    }
}

