/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.BpmnFactory;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.impl.ActivityImpl;
import org.eclipse.stp.bpmn.impl.BpmnDiagramImpl;
import org.eclipse.stp.bpmn.impl.GraphImpl;
import org.eclipse.stp.bpmn.impl.IdentifiableImpl;
import org.eclipse.stp.bpmn.impl.LaneImpl;
import org.eclipse.stp.bpmn.impl.MessagingEdgeImpl;
import org.eclipse.stp.bpmn.impl.PoolImpl;
import org.eclipse.stp.bpmn.impl.SequenceEdgeImpl;
import org.eclipse.stp.bpmn.impl.SubProcessImpl;
import org.eclipse.stp.bpmn.impl.VertexImpl;

public class BpmnFactoryImpl
extends EFactoryImpl
implements BpmnFactory {
    public static final String copyright = "";

    public static BpmnFactory init() {
        try {
            BpmnFactory theBpmnFactory = (BpmnFactory)EPackage.Registry.INSTANCE.getEFactory("http://stp.eclipse.org/bpmn");
            if (theBpmnFactory != null) {
                return theBpmnFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BpmnFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createActivity();
            }
            case 1: {
                return this.createBpmnDiagram();
            }
            case 2: {
                return this.createGraph();
            }
            case 3: {
                return this.createIdentifiable();
            }
            case 4: {
                return this.createLane();
            }
            case 5: {
                return this.createMessagingEdge();
            }
            case 6: {
                return this.createPool();
            }
            case 7: {
                return this.createSequenceEdge();
            }
            case 8: {
                return this.createSubProcess();
            }
            case 9: {
                return this.createVertex();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.createActivityTypeFromString(eDataType, initialValue);
            }
            case 11: {
                return this.createActivityTypeObjectFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 10: {
                return this.convertActivityTypeToString(eDataType, instanceValue);
            }
            case 11: {
                return this.convertActivityTypeObjectToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Activity createActivity() {
        ActivityImpl activity = new ActivityImpl();
        activity.iD = EcoreUtil.generateUUID();
        return activity;
    }

    public BpmnDiagram createBpmnDiagram() {
        BpmnDiagramImpl bpmnDiagram = new BpmnDiagramImpl();
        bpmnDiagram.iD = EcoreUtil.generateUUID();
        return bpmnDiagram;
    }

    public Graph createGraph() {
        GraphImpl graph = new GraphImpl();
        return graph;
    }

    public Identifiable createIdentifiable() {
        IdentifiableImpl identifiable = new IdentifiableImpl();
        return identifiable;
    }

    public Lane createLane() {
        LaneImpl lane = new LaneImpl();
        lane.iD = EcoreUtil.generateUUID();
        return lane;
    }

    public MessagingEdge createMessagingEdge() {
        MessagingEdgeImpl messagingEdge = new MessagingEdgeImpl();
        messagingEdge.iD = EcoreUtil.generateUUID();
        return messagingEdge;
    }

    public Pool createPool() {
        PoolImpl pool = new PoolImpl();
        pool.setID(EcoreUtil.generateUUID());
        return pool;
    }

    public SequenceEdge createSequenceEdge() {
        SequenceEdgeImpl edge = new SequenceEdgeImpl();
        edge.iD = EcoreUtil.generateUUID();
        return edge;
    }

    public SubProcess createSubProcess() {
        SubProcessImpl subProcess = new SubProcessImpl();
        subProcess.iD = EcoreUtil.generateUUID();
        return subProcess;
    }

    public Vertex createVertex() {
        VertexImpl vertex = new VertexImpl();
        vertex.iD = EcoreUtil.generateUUID();
        return vertex;
    }

    public ActivityType createActivityTypeFromString(EDataType eDataType, String initialValue) {
        ActivityType result = ActivityType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertActivityTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ActivityType createActivityTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createActivityTypeFromString((EDataType)BpmnPackage.Literals.ACTIVITY_TYPE, initialValue);
    }

    public String convertActivityTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertActivityTypeToString((EDataType)BpmnPackage.Literals.ACTIVITY_TYPE, instanceValue);
    }

    public BpmnPackage getBpmnPackage() {
        return (BpmnPackage)this.getEPackage();
    }

    public static BpmnPackage getPackage() {
        return BpmnPackage.eINSTANCE;
    }
}

