/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.builder;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.validation.BpmnValidationPlugin;
import org.eclipse.stp.bpmn.validation.providers.BpmnValidationProvider;

public class BatchValidationBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "org.eclipse.stp.bpmn.validation.BatchValidationBuilder";
    private static GMFResourceFactory RESOURCE_FACTORY = new GMFResourceFactory();

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void checkBpmnResource(IResource resource, IProgressMonitor monitor) {
        if (resource instanceof IFile && resource.getName().endsWith(".bpmn_diagram")) {
            IFile file = (IFile)resource;
            try {
                file.deleteMarkers("org.eclipse.stp.bpmn.validation.diagnostic", false, 0);
            }
            catch (CoreException coreException) {}
            try {
                BatchValidationBuilder.validateDiagramFile(file, monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.getProject().accept((IResourceVisitor)new BpmnDiagramResourceVisitor(monitor));
        }
        catch (CoreException coreException) {}
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new BpmnDiagramResourceDeltaVisitor(monitor));
    }

    public static final void validateDiagramFile(IFile diagramFile, IProgressMonitor monitor) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn", RESOURCE_FACTORY);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("bpmn_diagram", RESOURCE_FACTORY);
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/gmf/runtime/1.0.0/notation", (Object)NotationPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://stp.eclipse.org/bpmn", (Object)BpmnPackage.eINSTANCE);
        IPath bpmnPath = diagramFile.getFullPath().removeFileExtension().addFileExtension("bpmn");
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(bpmnPath) == null) {
            BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.stp.bpmn.validation", 2, "The diagram " + diagramFile.getFullPath().toPortableString() + " has no corresponding model: " + bpmnPath, null));
            return;
        }
        URI uriBpmn = URI.createURI((String)("platform:/resource" + diagramFile.getFullPath().removeFileExtension().toPortableString() + ".bpmn"));
        URI uriBpmnDiagram = URI.createURI((String)("platform:/resource" + diagramFile.getFullPath().toPortableString()));
        Resource resBpmn = resourceSet.createResource(uriBpmn);
        Resource resBpmnDiag = resourceSet.createResource(uriBpmnDiagram);
        resBpmnDiag.load(GMFResourceFactory.getDefaultLoadOptions());
        resBpmn.load(GMFResourceFactory.getDefaultLoadOptions());
        EList selectedEObjects = resBpmnDiag.getContents();
        if (selectedEObjects.isEmpty()) {
            BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.stp.bpmn.validation", 2, "The diagram " + diagramFile.getFullPath().toPortableString() + " was empty.", null));
            return;
        }
        monitor.setTaskName("Validate diagram " + diagramFile.getFullPath().toPortableString());
        for (EObject eobj : selectedEObjects) {
            if (!(eobj instanceof Diagram)) continue;
            Diagram diagram = (Diagram)eobj;
            try {
                BpmnValidationProvider.ValidateAction.runValidation((View)diagram);
            }
            catch (Exception e) {
                BpmnValidationPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.validation", 4, "Validation action failed", (Throwable)e));
            }
        }
        monitor.done();
    }

    class BpmnDiagramResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        IProgressMonitor _monitor;

        BpmnDiagramResourceDeltaVisitor(IProgressMonitor monitor) {
            this._monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    BatchValidationBuilder.this.checkBpmnResource(resource, this._monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    BatchValidationBuilder.this.checkBpmnResource(resource, this._monitor);
                }
            }
            return true;
        }
    }

    class BpmnDiagramResourceVisitor
    implements IResourceVisitor {
        IProgressMonitor _monitor;

        BpmnDiagramResourceVisitor(IProgressMonitor monitor) {
            this._monitor = monitor;
        }

        public boolean visit(IResource resource) {
            BatchValidationBuilder.this.checkBpmnResource(resource, this._monitor);
            return true;
        }
    }
}

