/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.MessagingEdge;

public class MessagingEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof MessagingEdge && (ctx.getFeature() == null || ctx.getFeature().getFeatureID() == 5)) {
            MessagingEdge edge = (MessagingEdge)ctx.getTarget();
            Activity source = edge.getSource();
            Activity target = edge.getTarget();
            switch (source.getActivityType().getValue()) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return ctx.createFailureStatus(new Object[]{"End event should not be the start point of a messaging edge"});
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return ctx.createFailureStatus(new Object[]{"Intermediate event should not be the start point of a messaging edge"});
                }
                case 2: 
                case 3: 
                case 4: {
                    return ctx.createFailureStatus(new Object[]{"Start event should not be the start point of a messaging edge"});
                }
            }
            switch (target.getActivityType().getValue()) {
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    return ctx.createFailureStatus(new Object[]{"End event should not be the end point of a messaging edge"});
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return ctx.createFailureStatus(new Object[]{"Intermediate event should not be the end point of a messaging edge"});
                }
                case 2: 
                case 3: 
                case 4: {
                    return ctx.createFailureStatus(new Object[]{"Start event should not be the end point of a messaging edge"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

