/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;

public class SequenceEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        if (ctx.getTarget() instanceof SequenceEdge && (ctx.getFeature() == null || ctx.getFeature().getFeatureID() == 7)) {
            SequenceEdge edge = (SequenceEdge)ctx.getTarget();
            Vertex source = edge.getSource();
            Vertex target = edge.getTarget();
            if (source instanceof Activity) {
                switch (((Activity)source).getActivityType().getValue()) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        return ctx.createFailureStatus(new Object[]{"End event should not be the start point of a sequence edge"});
                    }
                }
            }
            if (target instanceof Activity) {
                switch (((Activity)target).getActivityType().getValue()) {
                    case 2: 
                    case 3: 
                    case 4: {
                        return ctx.createFailureStatus(new Object[]{"Start event should not be the end point of a sequence edge"});
                    }
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

