/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.validation.specification;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.Vertex;

public class UniqueDefaultEdgeConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        SequenceEdge edge;
        if (ctx.getTarget() instanceof SequenceEdge && (edge = (SequenceEdge)ctx.getTarget()).isIsDefault()) {
            if (!this.checkOk(edge.getSource(), false, edge)) {
                return ctx.createFailureStatus(new Object[]{this.getGatewayName(edge.getSource())});
            }
            if (!this.checkOk(edge.getTarget(), true, edge)) {
                return ctx.createFailureStatus(new Object[]{this.getGatewayName(edge.getTarget())});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean checkOk(Vertex vertex, boolean incoming, SequenceEdge target) {
        if (vertex instanceof Activity && ((Activity)vertex).getActivityType().getValue() == 18) {
            EList edges = incoming ? vertex.getIncomingEdges() : vertex.getOutgoingEdges();
            for (Object edge : edges) {
                if (!(edge instanceof SequenceEdge) || !((SequenceEdge)edge).isIsDefault() || edge.equals(target)) continue;
                return false;
            }
        }
        return true;
    }

    private String getGatewayName(Vertex v) {
        if (v instanceof Activity && ((Activity)v).getName() != null) {
            return ((Activity)v).getName();
        }
        return "XOR gateway";
    }
}

