/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.ui.IActionDelegate;

public abstract class AbstractDeleteAnnotationAction
implements IActionDelegate {
    private ISelection _selection;
    private EModelElement selectedElt;
    private IGraphicalEditPart selectedPart;

    public void run(IAction action) {
        try {
            this.deleteAnnotation();
        }
        catch (ExecutionException e) {
            BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
        }
    }

    private void deleteAnnotation() throws ExecutionException {
        if (this.selectedElt.getEAnnotation(this.getAnnotationSource()) != null) {
            DestroyElementRequest request = new DestroyElementRequest((EObject)this.selectedElt.getEAnnotation(this.getAnnotationSource()), true);
            DestroyElementCommand command = new DestroyElementCommand(request);
            command.execute(null, null);
            this.selectedPart.refresh();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            this._selection = null;
            return;
        }
        this._selection = (IStructuredSelection)selection;
        if (action != null) {
            this.updateSelectedEModelElement(this._selection);
            boolean ok = this.selectedElt != null && this.selectedPart != null;
            action.setEnabled(ok);
            if (ok) {
                System.err.println("about to update the text");
                action.setText(this.updateText(this.selectedElt));
                action.setImageDescriptor(this.updateImage(this.selectedElt));
                action.setDescription(this.updateDescription(this.selectedElt));
                action.setToolTipText(this.updateToolTipText(this.selectedElt));
            } else {
                action.setText(this.getDefaultLabel());
                action.setImageDescriptor(this.getDefaultImage());
                action.setDescription(this.getDefaultDescription());
                action.setToolTipText(this.getDefaultToolTipText());
            }
        }
    }

    protected String updateToolTipText(EModelElement elt) {
        return null;
    }

    protected String updateDescription(EModelElement elt) {
        return null;
    }

    protected abstract String updateText(EModelElement var1);

    protected abstract ImageDescriptor updateImage(EModelElement var1);

    protected void updateSelectedEModelElement(ISelection selection) {
        EModelElement elt;
        IGraphicalEditPart part;
        if (selection != null && selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IGraphicalEditPart && (part = (IGraphicalEditPart)((IStructuredSelection)selection).getFirstElement()) != null && part.getNotationView() != null && (elt = (EModelElement)part.getNotationView().getElement()).getEAnnotation(this.getAnnotationSource()) != null) {
            this.selectedElt = elt;
            this.selectedPart = part;
            return;
        }
        this.selectedElt = null;
        this.selectedPart = null;
    }

    protected abstract String getAnnotationSource();

    protected String getDefaultLabel() {
        return "Delete Annotation";
    }

    protected String getDefaultToolTipText() {
        return "No annotation are attached to this element";
    }

    protected ImageDescriptor getDefaultImage() {
        return null;
    }

    protected String getDefaultDescription() {
        return "No annotation are attached to this element";
    }

    protected EModelElement getSelectedElt() {
        return this.selectedElt;
    }

    protected void setSelectedElt(EModelElement selectedElt) {
        this.selectedElt = selectedElt;
    }

    public IGraphicalEditPart getSelectedPart() {
        return this.selectedPart;
    }

    public void setSelectedPart(IGraphicalEditPart selectedPart) {
        this.selectedPart = selectedPart;
    }
}

