/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ToggleCanonicalModeCommand;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.MoveElementsCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.diagram.actions.AbstractGroupUngroupAction;
import org.eclipse.stp.bpmn.diagram.actions.UngroupAction;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.SubProcessBorderFigure;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupAction
extends AbstractGroupUngroupAction {
    public static final String ACTION_ID = "groupAction";
    public static final String TOOLBAR_ACTION_ID = "toolbarGroupAction";
    static final String ICON_PATH = "icons/Group.gif";
    private static final String ACTION_TEXT = "Group";
    static final String TOOLTIP_TEXT = "Group Shapes(Create Sub-Process)";
    private List<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
    private Collection<SequenceEdgeEditPart> externalSrcConnection = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> externalTgtConnections = new ArrayList<SequenceEdgeEditPart>();
    private Collection<SequenceEdgeEditPart> internalConnections = new HashSet<SequenceEdgeEditPart>();

    public GroupAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
    }

    public GroupAction(IWorkbenchPart workbenchPart) {
        super(workbenchPart);
    }

    private static GroupAction createActionWithoutId(IWorkbenchPage workbenchPage) {
        GroupAction action = new GroupAction(workbenchPage);
        action.setText(ACTION_TEXT);
        action.setToolTipText(TOOLTIP_TEXT);
        BpmnDiagramEditorPlugin.getInstance();
        action.setImageDescriptor(BpmnDiagramEditorPlugin.findImageDescriptor(ICON_PATH));
        return action;
    }

    public static GroupAction createGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(ACTION_ID);
        return action;
    }

    public static GroupAction createToolbarGroupAction(IWorkbenchPage workbenchPage) {
        GroupAction action = GroupAction.createActionWithoutId(workbenchPage);
        action.setId(TOOLBAR_ACTION_ID);
        return action;
    }

    protected void doRun(IProgressMonitor progressMonitor) {
        IGraphicalEditPart firstEditPart = this.editParts.get(0);
        EditPart containerEditPart = firstEditPart.getParent();
        View container = (View)containerEditPart.getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        TransactionalEditingDomain domain = firstEditPart.getEditingDomain();
        IDiagramEditDomain diagramEditDomain = firstEditPart.getDiagramEditDomain();
        CreateElementRequest createRequest = new CreateElementRequest(domain, context, BpmnElementTypes.SubProcess_2002);
        CreateElementCommand cmd = new CreateElementCommand(createRequest);
        CreateViewRequest.ViewDescriptor viewDescriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new CreateElementRequestAdapter(createRequest), Node.class, Integer.toString(2002), -1, true, firstEditPart.getDiagramPreferencesHint());
        CreateCommand createCommand = new CreateCommand(domain, viewDescriptor, container);
        CompositeCommand cc = new CompositeCommand("Create new subprocess");
        ToggleCanonicalModeCommand canonicalCmd = new ToggleCanonicalModeCommand(context, false);
        cc.compose((IUndoableOperation)new CommandProxy((Command)canonicalCmd));
        cc.compose((IUndoableOperation)cmd);
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)new CommandProxy((Command)ToggleCanonicalModeCommand.getToggleCanonicalModeCommand((ToggleCanonicalModeCommand)canonicalCmd, (boolean)true)));
        try {
            cc.execute((IProgressMonitor)new NullProgressMonitor(), null);
            View subProcessView = (View)viewDescriptor.getAdapter(View.class);
            SubProcessEditPart subProcessEditPart = null;
            List chilren = containerEditPart.getChildren();
            for (Object child : chilren) {
                if (((EditPart)child).getModel() != subProcessView) continue;
                subProcessEditPart = (SubProcessEditPart)((Object)child);
                break;
            }
            cc = new GroupCommand(ACTION_TEXT, subProcessEditPart);
            ArrayList<SubProcessEditPart> tmp = new ArrayList<SubProcessEditPart>();
            tmp.add(subProcessEditPart);
            tmp.add((SubProcessEditPart)containerEditPart);
            canonicalCmd = ToggleCanonicalModeCommand.getToggleCanonicalModeCommand(tmp, (boolean)false);
            cc.compose((IUndoableOperation)new CommandProxy((Command)canonicalCmd));
            View subProcessBodyView = GroupAction.getSubProcessBodyView(subProcessView);
            Rectangle selectionBounds = null;
            for (IGraphicalEditPart editPart : this.editParts) {
                View elementView = (View)editPart.getModel();
                EObject element = ViewUtil.resolveSemanticElement((View)elementView);
                AddCommand reparentViewCmd = new AddCommand(editPart.getEditingDomain(), (IAdaptable)new EObjectAdapter((EObject)subProcessBodyView), (IAdaptable)new EObjectAdapter((EObject)elementView));
                cc.compose((IUndoableOperation)reparentViewCmd);
                ICommand reparentCommand = this.getSemanticReparentCommand(editPart.getEditingDomain(), element, createRequest.getNewElement());
                cc.compose((IUndoableOperation)reparentCommand);
                if (selectionBounds == null) {
                    selectionBounds = editPart.getFigure().getBounds().getCopy();
                    continue;
                }
                selectionBounds.union(editPart.getFigure().getBounds());
            }
            this.addChangeBoundsCommands(selectionBounds.getLocation(), cc);
            cc.compose((IUndoableOperation)GroupAction.getSubprocessSetBoundsCommand(subProcessEditPart, selectionBounds));
            GroupAction.reparentInnnerConnections(this.internalConnections, domain, createRequest.getNewElement(), cc);
            subProcessEditPart.getFigure().setBounds(selectionBounds);
            ICommand reparentExtConnCmd = this.getReparentExternalConnectionsCommand(subProcessEditPart);
            if (reparentExtConnCmd != null) {
                cc.compose((IUndoableOperation)reparentExtConnCmd);
            }
            cc.compose((IUndoableOperation)new CommandProxy((Command)ToggleCanonicalModeCommand.getToggleCanonicalModeCommand((ToggleCanonicalModeCommand)canonicalCmd, (boolean)true)));
            diagramEditDomain.getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)cc));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private ICommand getReparentExternalConnectionsCommand(ShapeNodeEditPart subProcessEditPart) {
        CompositeCommand cc = new CompositeCommand("Reparent extenal connections");
        int size = this.externalSrcConnection.size();
        int idx = 0;
        for (SequenceEdgeEditPart connection : this.externalSrcConnection) {
            cc.compose((IUndoableOperation)GroupAction.getReconnectSourceCommand((ConnectionEditPart)connection, subProcessEditPart, idx, size));
            ++idx;
        }
        idx = 0;
        size = this.externalTgtConnections.size();
        for (SequenceEdgeEditPart connection : this.externalTgtConnections) {
            cc.compose((IUndoableOperation)GroupAction.getReconnectTargetCommand((ConnectionEditPart)connection, subProcessEditPart, idx, size));
            ++idx;
        }
        return !cc.isEmpty() ? cc : null;
    }

    private static ICommand getSubprocessSetBoundsCommand(ShapeNodeEditPart subProcessEditPart, Rectangle selectionBounds) {
        selectionBounds.shrink(-5, -5);
        if (selectionBounds.x < 0) {
            selectionBounds.x = 0;
        }
        if (selectionBounds.y < 0) {
            selectionBounds.y = 0;
        }
        selectionBounds.height += SubProcessBorderFigure.getFixedHeightDP(subProcessEditPart.getFigure());
        return new SetBoundsCommand(subProcessEditPart.getEditingDomain(), "Set sub-process bounds", (IAdaptable)subProcessEditPart, selectionBounds);
    }

    private static View getSubProcessBodyView(View subProcessView) {
        EList children = subProcessView.getPersistedChildren();
        for (Object object : children) {
            View child = (View)object;
            if (!child.getType().equals(Integer.toString(5002))) continue;
            return child;
        }
        return null;
    }

    private void addChangeBoundsCommands(Point selectionBoundsLocation, CompositeCommand cc) {
        CompositeCommand shiftCommands = new CompositeCommand("Shift selected nodes");
        cc.compose((IUndoableOperation)shiftCommands);
        for (IGraphicalEditPart editPart : this.editParts) {
            Point p = editPart.getFigure().getBounds().getLocation();
            p.translate(-selectionBoundsLocation.x, -selectionBoundsLocation.y);
            SetBoundsCommand cmd = new SetBoundsCommand(editPart.getEditingDomain(), "Set new editpart location", (IAdaptable)editPart, p);
            shiftCommands.compose((IUndoableOperation)cmd);
        }
    }

    private void sortConnections(IGraphicalEditPart editPart, Collection<SequenceEdgeEditPart> internalConnections, Collection<SequenceEdgeEditPart> externalSrcConnection, Collection<SequenceEdgeEditPart> externalTgtConnections) {
        List srcConnections = editPart.getSourceConnections();
        for (Object connection : srcConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (this.editParts.contains(sequenceConnection.getTarget())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalSrcConnection.add(sequenceConnection);
        }
        List targetConnections = editPart.getTargetConnections();
        for (Object connection : targetConnections) {
            if (!(connection instanceof SequenceEdgeEditPart)) continue;
            SequenceEdgeEditPart sequenceConnection = (SequenceEdgeEditPart)((Object)connection);
            if (this.editParts.contains(sequenceConnection.getSource())) {
                internalConnections.add(sequenceConnection);
                continue;
            }
            externalTgtConnections.add(sequenceConnection);
        }
    }

    private ICommand getSemanticReparentCommand(TransactionalEditingDomain domain, EObject element, EObject container) {
        MoveRequest moveRequest = new MoveRequest(domain, container, element);
        MoveElementsCommand semanticMoveCmd = new MoveElementsCommand(moveRequest);
        return semanticMoveCmd;
    }

    public void refresh() {
        EditPart currElement;
        this.editParts.clear();
        this.internalConnections.clear();
        this.externalSrcConnection.clear();
        this.externalTgtConnections.clear();
        IStructuredSelection strSelection = this.getStructuredSelection();
        for (Object editPart : strSelection) {
            if (!(editPart instanceof IGraphicalEditPart)) continue;
            this.editParts.add((IGraphicalEditPart)editPart);
        }
        EditPart parentContainer = null;
        Iterator<IGraphicalEditPart> iterator = this.editParts.iterator();
        while (iterator.hasNext()) {
            IGraphicalEditPart editPart = iterator.next();
            EditPart container = editPart.getParent();
            if (editPart instanceof LaneEditPart || !(container instanceof PoolPoolCompartmentEditPart) && !(container instanceof SubProcessSubProcessBodyCompartmentEditPart)) {
                this.editParts.clear();
                break;
            }
            if (container instanceof SubProcessSubProcessBodyCompartmentEditPart && GroupAction.isInsideAnother(container, this.editParts)) {
                iterator.remove();
                continue;
            }
            if (parentContainer == null) {
                parentContainer = container;
                continue;
            }
            if (parentContainer == container) continue;
            this.editParts.clear();
            break;
        }
        for (IGraphicalEditPart editPart : this.editParts) {
            this.sortConnections(editPart, this.internalConnections, this.externalSrcConnection, this.externalTgtConnections);
        }
        EditPart element = null;
        for (SequenceEdgeEditPart connection : this.externalSrcConnection) {
            currElement = connection.getSource();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            this.setEnabled(false);
            return;
        }
        element = null;
        for (SequenceEdgeEditPart connection : this.externalTgtConnections) {
            currElement = connection.getTarget();
            if (element == null) {
                element = currElement;
                continue;
            }
            if (element == currElement) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!this.editParts.isEmpty());
    }

    private static boolean isInsideAnother(EditPart editPart, List editParts) {
        SubProcessEditPart subProcess = GroupAction.getSubProcess(editPart);
        while (subProcess != null) {
            if (editParts.contains((Object)subProcess)) {
                return true;
            }
            subProcess = GroupAction.getSubProcess(subProcess.getParent());
        }
        return false;
    }

    private static class GroupCommand
    extends CompositeCommand {
        private ICommand ungroupCommand = null;
        private EditPart parent;
        private Object model;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !GroupCommand.class.desiredAssertionStatus();
        }

        public GroupCommand(String label, SubProcessEditPart createdSubProcess) {
            super(label);
            this.parent = createdSubProcess.getParent();
            this.model = createdSubProcess.getModel();
        }

        public IStatus undo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.ungroupCommand == null) {
                SubProcessEditPart subProcess = null;
                for (Object childEditPart : this.parent.getChildren()) {
                    if (((EditPart)childEditPart).getModel() != this.model) continue;
                    subProcess = (SubProcessEditPart)((Object)childEditPart);
                    break;
                }
                if (!$assertionsDisabled && subProcess == null) {
                    throw new AssertionError();
                }
                this.ungroupCommand = UngroupAction.getUngroupCommand(subProcess);
            }
            return this.ungroupCommand.execute(progressMonitor, info);
        }

        public IStatus redo(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            return this.ungroupCommand.undo(progressMonitor, info);
        }
    }

    private static class AddCommand
    extends org.eclipse.gmf.runtime.diagram.core.commands.AddCommand {
        private IAdaptable parent;

        public AddCommand(TransactionalEditingDomain editingDomain, IAdaptable parent, IAdaptable child) {
            super(editingDomain, parent, child);
            this.parent = parent;
        }

        public List getAffectedFiles() {
            View view = (View)this.parent.getAdapter(View.class);
            if (view != null) {
                IFile file;
                ArrayList<IFile> result = new ArrayList<IFile>();
                Resource ressource = view.eResource();
                if (ressource != null && (file = WorkspaceSynchronizer.getFile((Resource)view.eResource())) != null) {
                    result.add(file);
                }
                return result;
            }
            return super.getAffectedFiles();
        }
    }
}

