/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.emf.type.core.MetamodelType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityGraphicalNodeEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.ActivityItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.connectionanchors.WrapperNodeFigureEx;
import org.eclipse.stp.bpmn.figures.connectionanchors.impl.ConnectionAnchorFactory;
import org.eclipse.stp.bpmn.policies.ConnectionHandleEditPolicyEx;
import org.eclipse.stp.bpmn.policies.GenericEAnnotationDropPolicy;
import org.eclipse.stp.bpmn.policies.ResizableActivityEditPolicy;
import org.eclipse.stp.bpmn.tools.AddChildLayoutListener;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;
import org.eclipse.swt.graphics.Font;

public class ActivityEditPart
extends ShapeNodeEditPart {
    private static final int SHAPE_RECTANGLE = 0;
    private static final int SHAPE_DIAMOND = 1;
    private static final int SHAPE_CIRCLE = 2;
    private static final int EVENT_FIGURE_SIZE = 30;
    private static final int GATEWAY_FIGURE_SIZE = 50;
    public static final Dimension ACTIVITY_FIGURE_SIZE = new Dimension(111, 61);
    public static final int VISUAL_ID = 2001;
    private int handlePosition;
    protected boolean isChildAdded = false;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private NodeFigure wrappedFigure;

    public ActivityEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityItemSemanticEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new ActivityGraphicalNodeEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new ActivityCanonicalEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.installEditPolicy("ConnectionHandlesPolicy", (EditPolicy)new ConnectionHandleEditPolicyEx());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new GenericEAnnotationDropPolicy((IGraphicalEditPart)this));
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    public void installEditPolicy(Object key, EditPolicy editPolicy) {
        super.installEditPolicy(key, editPolicy);
    }

    protected IFigure createNodeShapeGen() {
        ActivityFigure figure = new ActivityFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    protected IFigure createNodeShape() {
        ActivityFigure figure = (ActivityFigure)this.createNodeShapeGen();
        Activity activity = (Activity)this.getPrimaryView().getElement();
        this.setActivityTypeAndLabelAndLayout(figure, activity);
        figure.setLooping(activity.isLooping());
        return figure;
    }

    private boolean setActivityTypeAndLabelAndLayout(ActivityFigure activityFigure, Activity activity) {
        StackLayout layout;
        activityFigure.setActivityType(activity.getActivityType().getLiteral());
        boolean res = false;
        if (activity.getName() == null) {
            WrapLabel wl = activityFigure.getFigureActivityNameFigure();
            if (activity.getActivityType().equals(ActivityType.TASK_LITERAL) && !"Task".equals(wl.getText())) {
                wl.setText("Task");
            }
            res = true;
        }
        if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
            if (!(activityFigure.getLayoutManager() instanceof StackLayout)) {
                layout = new StackLayout();
                activityFigure.setLayoutManager((LayoutManager)layout);
                res = true;
            }
        } else if (!(activityFigure.getLayoutManager() instanceof ConstrainedToolbarLayout)) {
            layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            activityFigure.setLayoutManager((LayoutManager)layout);
            res = true;
        }
        return res;
    }

    public ActivityFigure getPrimaryShape() {
        return (ActivityFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityNameEditPart) {
            ((ActivityNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureActivityNameFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        return false;
    }

    protected NodeFigure createNodePlate() {
        return new WrapperNodeFigureEx(ConnectionAnchorFactory.INSTANCE, this.createWrappedFigure()){

            public Rectangle getHandleBounds() {
                Rectangle rectangle = super.getHandleBounds();
                Activity activity = (Activity)ActivityEditPart.this.getPrimaryView().getElement();
                if (activity.getActivityType().equals(ActivityType.TASK_LITERAL)) {
                    return rectangle;
                }
                IGraphicalEditPart activityNameEditPart = ActivityEditPart.this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
                int nameFigureHeight = activityNameEditPart.getFigure().getSize().height;
                return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height - nameFigureHeight);
            }

            public void setBounds(Rectangle rect) {
                boolean translate;
                int x = this.bounds.x;
                int y = this.bounds.y;
                boolean resize = rect.width != this.bounds.width || rect.height != this.bounds.height;
                boolean bl = translate = rect.x != x || rect.y != y;
                if ((resize || translate) && this.isVisible()) {
                    this.erase();
                }
                if (translate) {
                    int dx = rect.x - x;
                    int dy = rect.y - y;
                    this.primTranslate(dx, dy);
                }
                this.bounds.width = rect.width;
                this.bounds.height = rect.height;
                if (translate || resize) {
                    if (resize || ActivityEditPart.this.isChildAdded && translate) {
                        this.invalidate();
                    }
                    this.fireFigureMoved();
                    this.repaint();
                }
            }
        };
    }

    private NodeFigure createWrappedFigure() {
        Activity activity = (Activity)this.getPrimaryView().getElement();
        int activityType = activity.getActivityType().getValue();
        int shapeType = ActivityEditPart.getShapeType(activityType);
        if (shapeType == 0) {
            int width = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.width);
            int height = this.getMapMode().DPtoLP(ActivityEditPart.ACTIVITY_FIGURE_SIZE.height);
            this.wrappedFigure = new ActivityNodeFigure(width, height);
        } else {
            this.wrappedFigure = shapeType == 1 ? new ActivityNodeFigure(0, 0) : new ActivityNodeFigure(0, 0);
        }
        this.wrappedFigure.setLayoutManager((LayoutManager)new StackLayout());
        return this.wrappedFigure;
    }

    private void buildFigure(IFigure container, IFigure shape, WrapLabel wrapLabel, int size) {
        int resultSize = this.getMapMode().DPtoLP(size);
        container.setSize(resultSize, resultSize);
        this.wrappedFigure.setLayoutManager((LayoutManager)new BorderLayout());
        container.setLayoutManager((LayoutManager)new StackLayout());
        container.add(shape);
        this.wrappedFigure.add(container, (Object)BorderLayout.CENTER);
        this.wrappedFigure.add((IFigure)wrapLabel, (Object)BorderLayout.BOTTOM);
        ((ActivityFigure)shape).setFigureActivityNameFigure(wrapLabel);
        this.contentPane = this.setupContentPane((IFigure)this.wrappedFigure);
    }

    private void changeActivitySize(Font oldFont, Font newFont) {
        String text;
        IFigure child = ((IGraphicalEditPart)this.getPrimaryChildEditPart()).getFigure();
        int fontDiff = FigureUtilities.getTextExtents((String)"", (Font)newFont).height - FigureUtilities.getTextExtents((String)"", (Font)oldFont).height;
        if (fontDiff != 0 && child instanceof WrapLabel && (text = ((WrapLabel)child).getText()) != null && text.length() > 0) {
            Rectangle oldBounds = this.getNodeFigure().getBounds();
            this.changeBounds(new Rectangle(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height + fontDiff));
        }
    }

    private void changeActivitySize(String oldNameText, String newNameText) {
        boolean isEmpty;
        IFigure child = ((IGraphicalEditPart)this.getPrimaryChildEditPart()).getFigure();
        Rectangle oldBounds = this.getNodeFigure().getBounds();
        int wrapLabelHeight = FigureUtilities.getTextExtents((String)"", (Font)child.getFont()).height;
        boolean wasEmpty = oldNameText == null || oldNameText.trim().length() == 0;
        boolean bl = isEmpty = newNameText == null || newNameText.trim().length() == 0;
        if (wasEmpty == isEmpty) {
            return;
        }
        int height = wasEmpty && !isEmpty ? wrapLabelHeight : -wrapLabelHeight;
        this.changeBounds(new Rectangle(oldBounds.x, oldBounds.y, oldBounds.width, oldBounds.height + height));
    }

    private void changeBounds(Rectangle newBounds) {
        SetBoundsCommand cmd = new SetBoundsCommand(this.getEditingDomain(), "Change node figure size", (IAdaptable)this, newBounds);
        this.getDiagramEditDomain().getDiagramCommandStack().execute((Command)new ICommandProxy((ICommand)cmd));
    }

    protected NodeFigure createNodeFigure() {
        boolean event;
        NodeFigure figure = this.createNodePlate();
        IFigure shape = this.createNodeShape();
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        if (gateway) {
            int size = this.getMapMode().DPtoLP(50);
            ActivityDiamondFigure diamondFigure = new ActivityDiamondFigure(new Dimension(size, size));
            this.buildFigure((IFigure)diamondFigure, shape, new ResizableWrapLabel(), 50);
        } else if (event) {
            ActivityOvalFigure ovalFigure = new ActivityOvalFigure();
            this.buildFigure((IFigure)ovalFigure, shape, new ResizableWrapLabel(), 30);
        } else {
            this.wrappedFigure.add(shape);
            this.contentPane = this.setupContentPane(shape);
        }
        figure.addLayoutListener((LayoutListener)new AddChildLayoutListener((EditPart)this));
        figure.addLayoutListener((LayoutListener)new LayoutListener.Stub(){

            public void postLayout(IFigure container) {
                boolean initialLayout;
                super.postLayout(container);
                boolean bl = initialLayout = ActivityEditPart.this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width()).equals(-1) && ActivityEditPart.this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height()).equals(-1);
                if (initialLayout) {
                    ActivityEditPart.this.changeBounds(ActivityEditPart.this.getNodeFigure().getBounds());
                }
            }
        });
        return figure;
    }

    protected IFigure setupContentPaneGen(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            EObject element = ((Node)this.getModel()).getElement();
            int activityType = ((Activity)element).getActivityType().getValue();
            if (activityType == 0) {
                StackLayout layout = new StackLayout();
                nodeShape.setLayoutManager((LayoutManager)layout);
            } else {
                return this.setupContentPaneGen(nodeShape);
            }
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001));
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    private boolean isEventOrGateway() {
        boolean event;
        ActivityType activityType = ((Activity)this.getPrimaryView().getElement()).getActivityType();
        boolean gateway = ActivityType.VALUES_GATEWAYS.contains(activityType);
        boolean bl = event = ActivityType.VALUES_EVENTS.contains(activityType) || ActivityType.VALUES_EVENTS_INTERMEDIATE.contains(activityType);
        return gateway || event;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1) {
            if (BpmnPackage.eINSTANCE.getActivity_ActivityType().equals(notification.getFeature())) {
                ActivityType oldActivityType = (ActivityType)notification.getOldValue();
                ActivityType newActivityType = (ActivityType)notification.getNewValue();
                this.maybeChangeFigure(oldActivityType, newActivityType);
                this.getPrimaryShape().setActivityType(newActivityType.getLiteral());
            } else if (BpmnPackage.eINSTANCE.getActivity_Looping().equals(notification.getFeature())) {
                this.getPrimaryShape().setLooping(notification.getNewBooleanValue());
            } else if (NotationPackage.eINSTANCE.getSize_Width().equals(notification.getFeature()) || NotationPackage.eINSTANCE.getSize_Height().equals(notification.getFeature())) {
                this.setChildAdded(true);
            } else if (BpmnPackage.eINSTANCE.getActivity_Name().equals(notification.getFeature()) && this.isEventOrGateway()) {
                this.changeActivitySize(notification.getOldStringValue(), notification.getNewStringValue());
            }
            Activity activity = (Activity)this.getPrimaryView().getElement();
            if (this.setActivityTypeAndLabelAndLayout(this.getPrimaryShape(), activity)) {
                this.refreshVisuals();
            }
        }
        super.handleNotificationEvent(notification);
    }

    private void maybeChangeFigure(ActivityType oldActivityType, ActivityType newActivityType) {
        int oldShape = ActivityEditPart.getShapeType(oldActivityType.getValue());
        int newShape = ActivityEditPart.getShapeType(newActivityType.getValue());
        if (newShape != oldShape) {
            this.wrappedFigure.remove(this.primaryShape);
            this.createWrappedFigure();
            ((WrapperNodeFigureEx)this.figure).setSubfigure(this.wrappedFigure);
            this.wrappedFigure.add(this.primaryShape);
            List targetConnections = this.getTargetConnections();
            for (ConnectionNodeEditPart edgeEditPart : targetConnections) {
                PolylineConnectionEx figure = (PolylineConnectionEx)edgeEditPart.getFigure();
                ConnectionAnchor currentAnchor = figure.getTargetAnchor();
                Point refPoint = currentAnchor.getReferencePoint();
                figure.setTargetAnchor(this.wrappedFigure.getTargetConnectionAnchorAt(refPoint));
            }
            List srcConnections = this.getSourceConnections();
            for (ConnectionNodeEditPart edgeEditPart : srcConnections) {
                PolylineConnectionEx figure = (PolylineConnectionEx)edgeEditPart.getFigure();
                ConnectionAnchor currentAnchor = figure.getSourceAnchor();
                Point refPoint = currentAnchor.getReferencePoint();
                figure.setSourceAnchor(this.wrappedFigure.getSourceConnectionAnchorAt(refPoint));
            }
        }
    }

    protected void refreshSourceConnections() {
        super.refreshSourceConnections();
        EList messages = ((Activity)((Node)this.getModel()).getElement()).getOrderedMessages();
        if (messages.size() > 0) {
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getSourceConnections(), true);
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getTargetConnections(), false);
        }
    }

    protected void refreshTargetConnections() {
        super.refreshTargetConnections();
        EList messages = ((Activity)((Node)this.getModel()).getElement()).getOrderedMessages();
        if (messages.size() > 0) {
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getSourceConnections(), true);
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getTargetConnections(), false);
            List targetConnections = this.getTargetConnections();
            for (Object object : targetConnections) {
                MessagingEdgeEditPart connEditPart;
                ActivityEditPart oppositeActivity;
                if (!(object instanceof MessagingEdgeEditPart) || (oppositeActivity = (ActivityEditPart)(connEditPart = (MessagingEdgeEditPart)((Object)object)).getSource()) == null) continue;
                EList oppositeSideMessages = ((Activity)((Node)oppositeActivity.getModel()).getElement()).getOrderedMessages();
                ActivityEditPart.updateMessagesIndexes((List)oppositeSideMessages, oppositeActivity.getSourceConnections(), true);
                ActivityEditPart.updateMessagesIndexes((List)messages, oppositeActivity.getTargetConnections(), false);
            }
        }
    }

    private void updateMessagesIndexes() {
        EList messages = ((Activity)((Node)this.getModel()).getElement()).getOrderedMessages();
        if (messages.size() > 0) {
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getSourceConnections(), true);
            ActivityEditPart.updateMessagesIndexes((List)messages, this.getTargetConnections(), false);
        }
    }

    private static void updateMessagesIndexes(List messages, List connectionsEditParts, boolean isSource) {
        int len = messages.size();
        for (Object object : connectionsEditParts) {
            ConnectionEditPart connEditPart = (ConnectionEditPart)object;
            View model = (View)connEditPart.getModel();
            int idx = messages.indexOf(model.getElement());
            if (idx <= -1) continue;
            PolylineConnectionEx connFigure = (PolylineConnectionEx)connEditPart.getFigure();
            ConnectionAnchor anchor = isSource ? connFigure.getSourceAnchor() : connFigure.getTargetAnchor();
            if (!(anchor instanceof IModelAwareAnchor)) continue;
            ((IModelAwareAnchor)anchor).setConnectionType(isSource, String.valueOf(3002), idx, len);
            connEditPart.refresh();
        }
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        return new ResizableActivityEditPolicy();
    }

    private static int getShapeType(int activityType) {
        int shapeType;
        switch (activityType) {
            case 0: {
                shapeType = 0;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                shapeType = 1;
                break;
            }
            default: {
                shapeType = 2;
            }
        }
        return shapeType;
    }

    public Command getCommand(Request _request) {
        Object model;
        if (_request instanceof CreateUnspecifiedTypeConnectionRequest && (model = ((CreateUnspecifiedTypeConnectionRequest)_request).getTargetEditPart().getModel()) instanceof Node) {
            CreateUnspecifiedTypeConnectionRequest request;
            List elTypes = ((CreateUnspecifiedTypeConnectionRequest)_request).getElementTypes();
            MetamodelType connType = (MetamodelType)BpmnElementTypes.MessagingEdge_3002;
            int i = 0;
            while (i < elTypes.size()) {
                if (elTypes.get(i) instanceof MetamodelType) {
                    connType = (MetamodelType)elTypes.get(i);
                    break;
                }
                ++i;
            }
            if (connType == BpmnElementTypes.MessagingEdge_3002) {
                MessageConnectionValidator messageValidator = new MessageConnectionValidator();
                if (_request instanceof CreateUnspecifiedTypeConnectionRequest && !(request = (CreateUnspecifiedTypeConnectionRequest)_request).isDirectionReversed()) {
                    if (request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                            if (!(connectionRequest.getSourceEditPart() != null && connectionRequest.getTargetEditPart() != null && connectionRequest.getSourceEditPart() == request.getSourceEditPart() && connectionRequest.getTargetEditPart() == request.getTargetEditPart() ? !messageValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart()) : !messageValidator.canConnect(request.getTargetEditPart(), request.getSourceEditPart()))) continue;
                            return null;
                        }
                    }
                    if (request.getSourceEditPart() == null && request.getTargetEditPart() != null && !messageValidator.canStart(request.getTargetEditPart())) {
                        return null;
                    }
                }
            }
            if (connType == BpmnElementTypes.SequenceEdge_3001) {
                EdgeConnectionValidator edgeValidator = new EdgeConnectionValidator();
                if (_request instanceof CreateUnspecifiedTypeConnectionRequest && !(request = (CreateUnspecifiedTypeConnectionRequest)_request).isDirectionReversed()) {
                    if (request.getSourceEditPart() != null && request.getTargetEditPart() != null) {
                        if (request.getSourceEditPart().equals(request.getTargetEditPart())) {
                            return null;
                        }
                        for (CreateConnectionRequest connectionRequest : request.getAllRequests()) {
                            if (!(connectionRequest.getSourceEditPart() != null && connectionRequest.getTargetEditPart() != null && connectionRequest.getSourceEditPart() == request.getSourceEditPart() && connectionRequest.getTargetEditPart() == request.getTargetEditPart() ? !edgeValidator.canConnect(request.getSourceEditPart(), request.getTargetEditPart()) : !edgeValidator.canConnect(request.getTargetEditPart(), request.getSourceEditPart()))) continue;
                            return null;
                        }
                    }
                    if (request.getSourceEditPart() == null && request.getTargetEditPart() != null && !edgeValidator.canStart(request.getTargetEditPart())) {
                        return null;
                    }
                }
            }
        }
        return super.getCommand(_request);
    }

    public boolean isChildAdded() {
        return this.isChildAdded;
    }

    public void setChildAdded(boolean isChildAdded) {
        this.isChildAdded = isChildAdded;
    }

    public DragTracker getDragTracker(Request request) {
        return new TaskDragEditPartsTrackerEx((EditPart)this);
    }

    public int getHandlePosition() {
        return this.handlePosition;
    }

    public void setHandlePosition(int handlePosition) {
        this.handlePosition = handlePosition;
    }

    private class ResizableWrapLabel
    extends WrapLabel {
        ResizableWrapLabel() {
        }

        public void setText(String s) {
            String s1 = s.trim();
            if (s.length() != 0 && s1.length() == 0) {
                s = s1;
            }
            super.setText(s);
        }

        public void setFont(Font f) {
            Font oldFont = super.getFont();
            super.setFont(f);
            ActivityEditPart.this.changeActivitySize(oldFont, f);
        }
    }

    public class ActivityFigure
    extends org.eclipse.stp.bpmn.figures.activities.ActivityFigure {
        private WrapLabel fActivityNameFigure;
        private boolean myUseLocalCoordinates = false;

        public ActivityFigure() {
            this.setActivityType("Task");
            this.setForegroundColor(ColorConstants.black);
            this.createContents();
        }

        private void createContents() {
            ActivityType activityType = ((Activity)ActivityEditPart.this.getPrimaryView().getElement()).getActivityType();
            if (activityType.equals(ActivityType.TASK_LITERAL)) {
                this.createContentsGen();
            }
        }

        private void createContentsGen() {
            WrapLabel fig_0 = new WrapLabel();
            fig_0.setText("Task");
            this.setFigureActivityNameFigure(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrapLabel getFigureActivityNameFigure() {
            return this.fActivityNameFigure;
        }

        private void setFigureActivityNameFigure(WrapLabel fig) {
            this.fActivityNameFigure = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

