/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityName2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.LaneNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.MessagingEdgeNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessNameEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.TextAnnotationEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Text;

public class BpmnEditPartFactory
implements EditPartFactory {
    public static final String EXTERNAL_NODE_LABELS_LAYER = "External Node Labels";

    public EditPart createEditPartGen(EditPart context, Object model) {
        if (model instanceof View) {
            View view = (View)model;
            int viewVisualID = BpmnVisualIDRegistry.getVisualID(view);
            switch (viewVisualID) {
                case 1001: {
                    return new PoolEditPart(view);
                }
                case 4005: {
                    return new PoolNameEditPart(view);
                }
                case 2001: {
                    return new ActivityEditPart(view);
                }
                case 4001: {
                    return new ActivityNameEditPart(view);
                }
                case 2002: {
                    return new SubProcessEditPart(view);
                }
                case 4003: {
                    return new SubProcessNameEditPart(view);
                }
                case 2003: {
                    return new Activity2EditPart(view);
                }
                case 4002: {
                    return new ActivityName2EditPart(view);
                }
                case 2004: {
                    return new LaneEditPart(view);
                }
                case 4004: {
                    return new LaneNameEditPart(view);
                }
                case 5001: {
                    return new PoolPoolCompartmentEditPart(view);
                }
                case 5002: {
                    return new SubProcessSubProcessBodyCompartmentEditPart(view);
                }
                case 5003: {
                    return new SubProcessSubProcessBorderCompartmentEditPart(view);
                }
                case 79: {
                    return new BpmnDiagramEditPart(view);
                }
                case 3001: {
                    return new SequenceEdgeEditPart(view);
                }
                case 4006: {
                    return new SequenceEdgeNameEditPart(view);
                }
                case 3002: {
                    return new MessagingEdgeEditPart(view);
                }
                case 4007: {
                    return new MessagingEdgeNameEditPart(view);
                }
            }
        }
        return this.createUnrecognizedEditPart(context, model);
    }

    public EditPart createEditPart(EditPart context, Object model) {
        View view;
        if (model instanceof View && (ViewType.NOTE.equals((view = (View)model).getType()) || ViewType.TEXT.equals(view.getType()))) {
            return new TextAnnotationEditPart(view);
        }
        return this.createEditPartGen(context, model);
    }

    private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
        return null;
    }

    public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
        if (source.getFigure() instanceof WrapLabel) {
            return new TextCellEditorLocator((WrapLabel)source.getFigure());
        }
        IFigure figure = source.getFigure();
        return new LabelCellEditorLocator((Label)figure);
    }

    private static class TextCellEditorLocator
    implements CellEditorLocator {
        private WrapLabel wrapLabel;

        public TextCellEditorLocator(WrapLabel wrapLabel) {
            this.wrapLabel = wrapLabel;
        }

        public WrapLabel getWrapLabel() {
            return this.wrapLabel;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getWrapLabel().getTextBounds().getCopy();
            this.getWrapLabel().translateToAbsolute((Translatable)rect);
            if (this.getWrapLabel().isTextWrapped() && this.getWrapLabel().getText().length() > 0) {
                rect.setSize(new Dimension(text.computeSize(rect.width, -1)));
            } else {
                int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
                rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            }
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }

    private static class LabelCellEditorLocator
    implements CellEditorLocator {
        private Label label;

        public LabelCellEditorLocator(Label label) {
            this.label = label;
        }

        public Label getLabel() {
            return this.label;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.getLabel().getTextBounds().getCopy();
            this.getLabel().translateToAbsolute((Translatable)rect);
            int avr = FigureUtilities.getFontMetrics((Font)text.getFont()).getAverageCharWidth();
            rect.setSize(new Dimension(text.computeSize(-1, -1)).expand(avr * 2, 0));
            if (!rect.equals((Object)new Rectangle(text.getBounds()))) {
                text.setBounds(rect.x, rect.y, rect.width, rect.height);
            }
        }
    }
}

