/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.MessagingEdgeItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.figures.ConnectionLayerExEx;
import org.eclipse.stp.bpmn.figures.ConnectionUtils;
import org.eclipse.stp.bpmn.figures.MessagePolylineSourceDecoration;
import org.eclipse.stp.bpmn.figures.MessagePolylineTargetDecoration;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.policies.GenericEAnnotationDropPolicy;

public class MessagingEdgeEditPart
extends ConnectionNodeEditPart {
    private static final int[] DASHES = new int[]{7, 5};
    public static final int VISUAL_ID = 3002;
    private ConnectionRouter rectilinearRouter = null;
    private EditPart srcConnEditPart = null;
    private EditPart trgConnEditPart = null;

    public MessagingEdgeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MessagingEdgeItemSemanticEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new GenericEAnnotationDropPolicy((IGraphicalEditPart)this));
    }

    protected Connection createConnectionFigure() {
        return new ConnectionMessageFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    this.rectilinearRouter = cLayerEx.getBpmnMessagingEdgeRectilinearRouter();
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((ConnectionMessageFigure)this.getFigure()).routerIsRectilinear = true;
                this.refreshRouterChange();
                return;
            }
        }
        ((ConnectionMessageFigure)this.getFigure()).routerIsRectilinear = false;
        super.installRouter();
    }

    private static EditPart getRealEditPart(EditPart editPart) {
        EditPart res = editPart;
        EditPart parent = editPart.getParent();
        while (!(parent instanceof PoolPoolCompartmentEditPart)) {
            boolean isCollapsed;
            if (parent instanceof SubProcessSubProcessBodyCompartmentEditPart && (isCollapsed = ((Boolean)((SubProcessSubProcessBodyCompartmentEditPart)parent).getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getDrawerStyle_Collapsed())).booleanValue())) {
                res = parent.getParent();
            }
            parent = parent.getParent();
        }
        return res;
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        EditPart newSrcEditPart;
        EditPart editPart = this.getSource();
        if (editPart != null && (newSrcEditPart = MessagingEdgeEditPart.getRealEditPart(editPart)) != editPart) {
            EditPart targetEditPart = this.getTarget();
            if (targetEditPart != null) {
                targetEditPart = MessagingEdgeEditPart.getRealEditPart(targetEditPart);
            }
            if (newSrcEditPart != targetEditPart) {
                this.srcConnEditPart = newSrcEditPart;
                ConnectionAnchor ca = ((NodeEditPart)this.srcConnEditPart).getSourceConnectionAnchor((ConnectionEditPart)this);
                this.updateConnectionAnchor(ca, true);
                return ca;
            }
            this.srcConnEditPart = editPart;
        }
        ConnectionAnchor ca = super.getSourceConnectionAnchor();
        this.updateConnectionAnchor(ca, true);
        return ca;
    }

    private void updateConnectionAnchor(ConnectionAnchor ca, boolean isSource) {
        if (ca instanceof IModelAwareAnchor) {
            IModelAwareAnchor modelAware = (IModelAwareAnchor)ca;
            MessagingEdge msgEdge = (MessagingEdge)this.getPrimaryView().getElement();
            EList messages = isSource ? ((Activity)((GraphicalEditPart)super.getSource()).getPrimaryView().getElement()).getOrderedMessages() : ((Activity)((GraphicalEditPart)super.getTarget()).getPrimaryView().getElement()).getOrderedMessages();
            int ind = messages.indexOf((Object)msgEdge);
            int count = messages.size();
            modelAware.setConnectionType(isSource, String.valueOf(3002), ind, count);
        }
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        EditPart newTargetEditPart;
        EditPart editPart = this.getTarget();
        if (editPart != null && (newTargetEditPart = MessagingEdgeEditPart.getRealEditPart(editPart)) != editPart) {
            EditPart srcEditPart = this.getSource();
            if (srcEditPart != null) {
                srcEditPart = MessagingEdgeEditPart.getRealEditPart(srcEditPart);
            }
            if (newTargetEditPart != srcEditPart) {
                this.trgConnEditPart = newTargetEditPart;
                ConnectionAnchor ca = ((NodeEditPart)this.trgConnEditPart).getTargetConnectionAnchor((ConnectionEditPart)this);
                this.updateConnectionAnchor(ca, false);
                return ca;
            }
            this.trgConnEditPart = editPart;
        }
        ConnectionAnchor ca = super.getTargetConnectionAnchor();
        this.updateConnectionAnchor(ca, false);
        return ca;
    }

    private boolean isReparented() {
        return this.srcConnEditPart != null && this.srcConnEditPart != this.getSource() || this.trgConnEditPart != null && this.trgConnEditPart != this.getTarget();
    }

    protected void handleNotificationEvent(Notification notification) {
        String newValue;
        Object feature = notification.getFeature();
        if (feature instanceof EAttribute && "anchor".equals(((EAttribute)feature).getDefaultValueLiteral()) && (newValue = notification.getNewStringValue()) != null) {
            Activity activity;
            boolean isSource;
            PrecisionPoint p = BaseSlidableAnchor.parseTerminalString((String)newValue);
            IdentityAnchor notifier = (IdentityAnchor)notification.getNotifier();
            Edge connection = (Edge)notifier.eContainer();
            if (connection.getSourceAnchor() == notifier) {
                isSource = true;
                activity = (Activity)connection.getSource().getElement();
            } else {
                isSource = false;
                activity = (Activity)connection.getTarget().getElement();
            }
            EList messages = activity.getOrderedMessages();
            int connCount = messages.size();
            int newIdx = -1;
            int i = 0;
            while (i < connCount) {
                if (p.preciseX < 1.0 / (double)connCount * (double)(i + 1)) {
                    newIdx = i;
                    break;
                }
                ++i;
            }
            if (newIdx != -1) {
                messages.move(newIdx, (Object)connection.getElement());
                EditPart activityEditPart = isSource ? this.getSource() : this.getTarget();
                activityEditPart.refresh();
            }
        }
        super.handleNotificationEvent(notification);
    }

    public class ConnectionMessageFigure
    extends PolylineConnectionEx {
        private static final int DELTA_ANCHOR_SIZE = 10;
        private boolean routerIsRectilinear = true;

        public ConnectionMessageFigure() {
            this.setLineStyle(6);
            this.setLineDash(DASHES);
            this.setForegroundColor(ColorConstants.black);
            this.setSourceDecoration(this.createSourceDecoration());
            this.setTargetDecoration((RotatableDecoration)this.createTargetDecoration());
        }

        private MessagePolylineSourceDecoration createSourceDecoration() {
            MessagePolylineSourceDecoration df = new MessagePolylineSourceDecoration();
            return df;
        }

        private MessagePolylineTargetDecoration createTargetDecoration() {
            MessagePolylineTargetDecoration df = new MessagePolylineTargetDecoration();
            return df;
        }

        public PointList getSmoothPoints() {
            PointList smoothPoints = !this.routerIsRectilinear ? super.getSmoothPoints() : ConnectionUtils.getRoundedRectilinearSmoothPoints(true, this.getPoints(), this.getSmoothness());
            return smoothPoints;
        }

        public void setVisible(boolean visible) {
            if (MessagingEdgeEditPart.this.isReparented()) {
                visible = true;
            }
            super.setVisible(visible);
        }
    }
}

