/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.providers.AbstractViewProvider;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;
import org.eclipse.stp.bpmn.diagram.view.factories.Activity2ViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.ActivityName2ViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.ActivityNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.ActivityViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.BpmnDiagramViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.LaneNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.LaneViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.MessagingEdgeNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.MessagingEdgeViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.PoolNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.PoolPoolCompartmentViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.PoolViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SequenceEdgeNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SequenceEdgeViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SubProcessNameViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SubProcessSubProcessBodyCompartmentViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SubProcessSubProcessBorderCompartmentViewFactory;
import org.eclipse.stp.bpmn.diagram.view.factories.SubProcessViewFactory;

public class BpmnViewProvider
extends AbstractViewProvider {
    protected Class getDiagramViewClass(IAdaptable semanticAdapter, String diagramKind) {
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        if (BpmnDiagramEditPart.MODEL_ID.equals(diagramKind) && BpmnVisualIDRegistry.getDiagramVisualID(semanticElement) != -1) {
            return BpmnDiagramViewFactory.class;
        }
        return null;
    }

    protected Class getNodeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        if (containerView == null) {
            return null;
        }
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (elementType != null && !BpmnElementTypes.isKnownElementType(elementType)) {
            return null;
        }
        EClass semanticType = this.getSemanticEClass(semanticAdapter);
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        int nodeVID = BpmnVisualIDRegistry.getNodeVisualID(containerView, semanticElement, semanticType, semanticHint);
        switch (nodeVID) {
            case 1001: {
                return PoolViewFactory.class;
            }
            case 4005: {
                return PoolNameViewFactory.class;
            }
            case 2001: {
                return ActivityViewFactory.class;
            }
            case 4001: {
                return ActivityNameViewFactory.class;
            }
            case 2002: {
                return SubProcessViewFactory.class;
            }
            case 4003: {
                return SubProcessNameViewFactory.class;
            }
            case 2003: {
                return Activity2ViewFactory.class;
            }
            case 4002: {
                return ActivityName2ViewFactory.class;
            }
            case 2004: {
                return LaneViewFactory.class;
            }
            case 4004: {
                return LaneNameViewFactory.class;
            }
            case 5001: {
                return PoolPoolCompartmentViewFactory.class;
            }
            case 5002: {
                return SubProcessSubProcessBodyCompartmentViewFactory.class;
            }
            case 5003: {
                return SubProcessSubProcessBorderCompartmentViewFactory.class;
            }
            case 4006: {
                return SequenceEdgeNameViewFactory.class;
            }
            case 4007: {
                return MessagingEdgeNameViewFactory.class;
            }
        }
        return null;
    }

    protected Class getEdgeViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        IElementType elementType = this.getSemanticElementType(semanticAdapter);
        if (elementType != null && !BpmnElementTypes.isKnownElementType(elementType)) {
            return null;
        }
        EClass semanticType = this.getSemanticEClass(semanticAdapter);
        if (semanticType == null) {
            return null;
        }
        EObject semanticElement = this.getSemanticElement(semanticAdapter);
        int linkVID = BpmnVisualIDRegistry.getLinkWithClassVisualID(semanticElement, semanticType);
        switch (linkVID) {
            case 3001: {
                return SequenceEdgeViewFactory.class;
            }
            case 3002: {
                return MessagingEdgeViewFactory.class;
            }
        }
        return this.getUnrecognizedConnectorViewClass(semanticAdapter, containerView, semanticHint);
    }

    private IElementType getSemanticElementType(IAdaptable semanticAdapter) {
        if (semanticAdapter == null) {
            return null;
        }
        return (IElementType)semanticAdapter.getAdapter(IElementType.class);
    }

    private Class getUnrecognizedConnectorViewClass(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        return null;
    }
}

